/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.chronopay;

import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import com.gridnine.xtrip.server.pg.PaymentChecker;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.chronopay.HandlerCompletePayment;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChronopayPGServlet
extends PGServlet {
    private static final long serialVersionUID = 7922731345526412986L;
    private static final Logger log = LoggerFactory.getLogger(ChronopayPGServlet.class);

    protected PgName getId() {
        return PgName.CHRONOPAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) {
        log.debug("service() BEGIN");
        PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
        Date startDate = new Date();
        Map request = PGHelper.convertRequestParametersMap((Map)req.getParameterMap());
        PGServletResponse response = new PGServletResponse(res);
        LinkedList<Message> messages = new LinkedList<Message>();
        LinkedList pgLog = new LinkedList();
        String paymentId = null;
        Payment payment = null;
        try {
            paymentId = req.getParameter("cs1");
            if (TextUtil.isBlank((String)paymentId)) {
                throw new Exception("missing parameter 'cs1'");
            }
            try (NamedLock lock = this.getLock(paymentId);){
                if (!lock.tryLock()) {
                    response.setResponseCode(500);
                    return;
                }
                try {
                    LogicalStorage.get().authorizeAsSystem();
                    PGInvocationContext.get().setPaymentId(paymentId);
                    payment = this.getFromQueue(paymentId);
                    if (payment == null) {
                        response.setResponseCode(200);
                        return;
                    }
                    HandlerCompletePayment.process(request, payment, messages);
                    response.setResponseCode(200);
                    PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                    PaymentChecker.schedule((Payment)payment, (SalesContext)PaymentHelper.restoreSalesContext((Payment)payment), (PgName)PgName.CHRONOPAY);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        catch (Throwable t) {
            log.error("service failed", t);
            response.setResponseCode(500);
            response.setResponseText(t.getMessage());
            PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, t);
        }
        finally {
            PGInvocationContext.get().end(this.getConnector(), pgLog);
            if (payment != null) {
                PGInvocationContext.get().saveDocs(pgLog, messages, payment.getPayee());
            }
            response.send();
            LogicalStorage.reset();
        }
        log.debug("service() END");
    }
}

