/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.chronopay;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Properties;

class Configuration {
    private final boolean traceEnabled;
    private final String redirectUrl;
    private final String callbackUrl;
    private final String gatewayUrl;
    private final Long queuePeriod;
    private final boolean autoReversalEnabled;

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }

    Configuration(Properties data) {
        this.traceEnabled = Configuration.isTrue(data.getProperty("trace.enabled"));
        this.redirectUrl = data.getProperty("redirect.url");
        this.callbackUrl = data.getProperty("callback.url");
        this.gatewayUrl = data.getProperty("gateway.url");
        this.queuePeriod = data.contains("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
        this.autoReversalEnabled = Configuration.isTrue(data.getProperty("auto.reversal.enabled"));
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    String getRedirectUrl() {
        return this.redirectUrl;
    }

    String getCallbackUrl() {
        return this.callbackUrl;
    }

    String getGatewayUrl() {
        return this.gatewayUrl;
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    boolean isValid() {
        return !TextUtil.isBlank((String)this.redirectUrl) && !TextUtil.isBlank((String)this.callbackUrl);
    }

    public boolean isAutoReversalEnabled() {
        return this.autoReversalEnabled;
    }
}

