/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.chronopay;

import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.BinHex;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.pg.chronopay.Configuration;
import java.math.BigDecimal;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

class HandlerInitiatePayment {
    private static final DecimalFormat priceFormatter;

    HandlerInitiatePayment() {
    }

    static void process(PaymentInitiationResult result, PaymentInitiationParameters parameters, PGParameters pgParameters, Configuration configuration) throws Exception {
        result.getRedirectForm().setUrl(configuration.getRedirectUrl());
        result.getRedirectForm().setMethod("POST");
        String productId = pgParameters.getPgAccount();
        boolean twoPhase = productId.endsWith("*");
        if (twoPhase) {
            productId = productId.substring(0, productId.length() - 1);
        }
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("site_id", productId.substring(0, productId.lastIndexOf(45))));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("product_id", productId));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("order_id", parameters.getPayment().getPaymentId()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("payment_type_group_id", HandlerInitiatePayment.encodePaymentType(parameters.getPayment().getPaymentType())));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("cs1", parameters.getPayment().getPaymentId()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("cs3", Boolean.toString(twoPhase)));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("cb_url", configuration.getCallbackUrl()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("success_url", parameters.getReturnUrl() + "&status=1"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("decline_url", parameters.getReturnUrl() + "&status=0"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("product_price", priceFormatter.format(parameters.getPayment().getAmount().doubleValue())));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("sign", HandlerInitiatePayment.generateSign(productId, parameters.getPayment().getAmount(), pgParameters.getPgPassword())));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("cs2", TranslitUtil.cyr2lat((String)parameters.getPayment().getDescription(), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006)));
    }

    private static String generateSign(String productId, BigDecimal productPrice, String sharedSecret) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(productId);
        sb.append('-');
        sb.append(priceFormatter.format(productPrice.doubleValue()));
        sb.append('-');
        sb.append(sharedSecret);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(Charset.forName("UTF-8").encode(CharBuffer.wrap(sb.toString().toCharArray())));
        return BinHex.encode((byte[])md5.digest());
    }

    private static NamedValue namedValue(String name, String value) {
        NamedValue nv = new NamedValue();
        nv.setName(name);
        nv.setValue(value);
        return nv;
    }

    private static String encodePaymentType(PaymentType paymentType) throws Exception {
        switch (paymentType) {
            case CREDIT_CARD_ONLINE_CHRONOPAY: {
                return "1";
            }
            case WEBMONEY_CHRONOPAY: {
                return "15";
            }
            case YANDEX_MONEY_CHRONOPAY: {
                return "16";
            }
        }
        throw new Exception(String.format("payment type %s is not supported by pg %s", paymentType.name(), PgName.CHRONOPAY.name()));
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        priceFormatter = new DecimalFormat("0.00", dfs);
    }
}

