/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.chronopay;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.w3c.dom.Element;

class HandlerXmlGateway {
    private static final CodeTranslator CODE_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.IATA.name(), CodeSystem.CRT.name()});

    HandlerXmlGateway() {
    }

    static Element prepareRequest(int opCode, Payment payment, PGParameters pgParameters) {
        String productId = pgParameters.getPgAccount();
        boolean twoPhase = productId.endsWith("*");
        if (twoPhase) {
            productId = productId.substring(0, productId.length() - 1);
        }
        Element request = XUtil.createElement((String)"request");
        XHelper.writeInt((Element)request, (String)"Opcode", (int)opCode);
        XHelper.writeString((Element)request, (String)"Product", (String)productId);
        XHelper.writeString((Element)request, (String)"Transaction", (String)payment.getPgPaymentId());
        StringBuilder sb = new StringBuilder();
        sb.append(pgParameters.getPgPassword());
        sb.append('-');
        sb.append(Integer.toString(opCode));
        sb.append('-');
        sb.append(productId);
        XHelper.writeString((Element)request, (String)"hash", (String)MiscUtil.md5((String)sb.toString()));
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void injectLongRecord(Element request, BookingFile bookingFile) throws Exception {
        Locale saveLocale = ((LocaleManager)Environment.getPublished(LocaleManager.class)).getCurrentLocale();
        ((LocaleManager)Environment.getPublished(LocaleManager.class)).setCurrentLocale(Locale.ENGLISH);
        try {
            for (Reservation reservation : bookingFile.getReservations()) {
                for (BaseProduct bp : reservation.getProducts()) {
                    if (!(bp instanceof Product)) continue;
                    Product prod = (Product)bp;
                    Element data = XmlUtil.addElement((Element)request, (String)"AirLine");
                    StringBuilder ticketNumber = new StringBuilder(TextUtil.nonNullStr((String)prod.getCarrierNumber()) + TextUtil.nonNullStr((String)prod.getSystemNumber()));
                    while (ticketNumber.toString().length() < 14) {
                        ticketNumber.insert(0, "0");
                    }
                    XHelper.writeString((Element)data, (String)"ticketNumber", (String)ticketNumber.toString());
                    SimpleDateFormat mmddyyyyFormat = new SimpleDateFormat("MMddyyyy");
                    XHelper.writeString((Element)data, (String)"ticketIssueDate", (String)mmddyyyyFormat.format(prod.getIssueDate()));
                    Organization agency = (Organization)((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(AirProductHelper.getAgency((Product)prod)).getEntity();
                    XHelper.writeString((Element)data, (String)"agencyName", (String)TranslitUtil.cyr2lat((String)L10nStringHelper.getValue((L10nString)agency.getShortName(), (Locale)((LocaleManager)Environment.getPublished(LocaleManager.class)).getCurrentLocale(), (boolean)false), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006));
                    Segment firstSegment = (Segment)((SegmentTariff)prod.getSegmentTariffs().get(0)).getSegments().get(0);
                    XHelper.writeString((Element)data, (String)"airportCode", (String)CODE_TRANSLATOR.getNativeCode(firstSegment.getDepartureLocation()));
                    XHelper.writeString((Element)data, (String)"departureDate", (String)mmddyyyyFormat.format(firstSegment.getStartDate()));
                    String passengerName = TranslitUtil.cyr2lat((String)TextUtil.buildFullName((PersonalName)prod.getTraveller().getPassport()), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.GOST_52535_1_2006);
                    XHelper.writeString((Element)data, (String)"passengerName", (String)(passengerName.length() <= 20 ? passengerName : passengerName.substring(0, 20)));
                    int i = 1;
                    SimpleDateFormat mmddyyFormat = new SimpleDateFormat("MMddyy");
                    block7: for (SegmentTariff st : prod.getSegmentTariffs()) {
                        for (Segment s : st.getSegments()) {
                            Element segment = XmlUtil.addElement((Element)data, (String)("segment" + String.valueOf(i)));
                            XHelper.writeString((Element)segment, (String)"carrierCodeLeg", (String)CODE_TRANSLATOR.getNativeCode(s.getAirline()));
                            XHelper.writeString((Element)segment, (String)"serviceClassLeg", (String)TranslitUtil.cyr2lat((String)s.getClassOfSvcCode(), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.SIRENA_SERVICE_CLASSES_RULES));
                            if (s.getNoOfStops() != null) {
                                XHelper.writeString((Element)segment, (String)"stopoverCodeLeg", (String)(s.getNoOfStops() > 0 ? "O" : "X"));
                            }
                            XHelper.writeString((Element)segment, (String)"destCityLeg", (String)CODE_TRANSLATOR.getNativeCode(s.getArriveLocation()));
                            XHelper.writeString((Element)segment, (String)"departureDateLeg", (String)mmddyyFormat.format(s.getStartDate()));
                            if (++i <= 4) continue;
                            break block7;
                        }
                    }
                    return;
                }
            }
        }
        finally {
            ((LocaleManager)Environment.getPublished(LocaleManager.class)).setCurrentLocale(saveLocale);
        }
    }

    static void processResponse(Element response) throws Exception {
        if (!"000".equals(XHelper.readString((Element)response, (String)"code"))) {
            throw new Exception(XHelper.readString((Element)response, (String)"message"));
        }
    }
}

