/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.clearpark;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

public class ClearParkHelper {
    static final String IS_CERT_MODE_ENABLED = "cert.mode.enabled";
    static final String IS_CERT_MODE_CASE = "cert.mode.case.";
    private static final AtomicInteger case4count = new AtomicInteger(0);

    static String getLanguage() {
        Locale loc = ((LocaleManager)Environment.getPublished(LocaleManager.class)).getCurrentLocale();
        String language = loc.getLanguage().toUpperCase();
        if ("RU".equals(language)) {
            return "RU";
        }
        if ("UK".equals(language)) {
            return "UK";
        }
        if ("EN".equals(language)) {
            return "EN";
        }
        if ("DE".equals(language)) {
            return "DE";
        }
        if ("EL".equals(language)) {
            return "EL";
        }
        if ("FR".equals(language)) {
            return "FR";
        }
        if ("LV".equals(language)) {
            return "LV";
        }
        if ("NL".equals(language)) {
            return "NL";
        }
        if ("NO".equals(language)) {
            return "NO";
        }
        if ("SE".equals(language)) {
            return "SE";
        }
        return "EN";
    }

    static boolean isWaiting(Map<String, String> request) {
        return "Waiting".equals(request.get("RESULT"));
    }

    static PaymentStatus native2Status(Map<String, String> request) {
        String result = request.get("RESULT");
        return "Waiting".equals(result) ? PaymentStatus.FAILED : ("Cancelled".equals(request.get("METHOD")) ? PaymentStatus.FAILED : ("Approved".equals(result) ? PaymentStatus.SUCCEEDED : PaymentStatus.FAILED));
    }

    static boolean checkOrder(Map<String, String> request, Payment payment, Properties configuration, boolean isCertMode) throws Exception {
        PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)ClearParkHelper.restorePgSalesContext(payment), (PgName)PgName.CLEARPARK, (Payment)payment);
        if (!pgParameters.getPgAccount().equals(request.get("CPID")) || !pgParameters.getPgPassword().equals(request.get("SECTOK"))) {
            return false;
        }
        String tia = request.get("TIA");
        if (tia.contains(",")) {
            tia = tia.replace(',', '.');
        }
        BigDecimal amount = new BigDecimal(tia);
        if (isCertMode) {
            if (ClearParkHelper.isCertModeCase(configuration, "1", payment.getPaymentId())) {
                payment.setAmount(new BigDecimal("1234.50"));
            } else if (ClearParkHelper.isCertModeCase(configuration, "2", payment.getPaymentId())) {
                payment.setAmount(new BigDecimal("300.00"));
            } else if (ClearParkHelper.isCertModeCase(configuration, "3", payment.getPaymentId())) {
                payment.setAmount(new BigDecimal("400.00"));
            } else if (ClearParkHelper.isCertModeCase(configuration, "4", payment.getPaymentId())) {
                payment.setAmount(new BigDecimal("500.00"));
            }
        }
        return amount.compareTo(payment.getAmount()) == 0;
    }

    static CardVendor getVendor(String method) {
        if ("VISA".equals(method)) {
            return CardVendor.VISA;
        }
        if ("MC".equals(method)) {
            return CardVendor.MASTERCARD;
        }
        if ("AMEX".equals(method)) {
            return CardVendor.AMEX;
        }
        return null;
    }

    static SalesContext restorePgSalesContext(Payment payment) throws Exception {
        BookingFile bf = (BookingFile)EntityStorage.get().resolve(payment.getEntity()).getEntity();
        Reservation res = (Reservation)bf.getReservations().get(0);
        SalesContext result = new SalesContext();
        result.setAgency(bf.getAgency());
        result.setAgent(res.getBookingAgent());
        result.setClient(bf.getCustomerProfile());
        result.setSalesPoint(res.getSalesPoint());
        result.setSubagency(res.getSubagency());
        return result;
    }

    static boolean isCertMode(Properties configuration) {
        return configuration.containsKey(IS_CERT_MODE_ENABLED) ? Boolean.valueOf((String)configuration.get(IS_CERT_MODE_ENABLED)) : false;
    }

    static boolean isCertModeCase(Properties configuration, String caseNo, String ordId) {
        String key = IS_CERT_MODE_CASE + caseNo;
        return configuration.containsKey(key) ? ordId.equals(configuration.get(key)) : false;
    }

    static boolean isCase4Ok() {
        return case4count.incrementAndGet() == 1;
    }
}

