/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.clearpark;

import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import com.gridnine.xtrip.server.pg.clearpark.ClearParkHelper;
import com.gridnine.xtrip.server.pg.clearpark.HandlerCompletePayment;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearParkPGServlet
extends PGServlet {
    private static final long serialVersionUID = 5107482932503807081L;
    private static final Logger log = LoggerFactory.getLogger(ClearParkPGServlet.class);

    protected PgName getId() {
        return PgName.CLEARPARK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        log.debug("service() BEGIN");
        PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
        Date startDate = new Date();
        Map request = PGHelper.convertRequestParametersMap((Map)req.getParameterMap());
        PGServletResponse response = new PGServletResponse(res);
        LinkedList<Message> messages = new LinkedList<Message>();
        LinkedList pgLog = new LinkedList();
        String paymentId = (String)request.get("ORDID");
        Payment payment = null;
        boolean isCertMode = ClearParkHelper.isCertMode(this.getConnector().getConfiguration());
        try (NamedLock lock = this.getLock(paymentId);){
            if (!lock.tryLock()) {
                log.error("Payment: " + paymentId + " already processing");
                response.setResponseCode(500);
                response.setResponseText("[NOK]");
                response.send();
                return;
            }
            try {
                block33: {
                    block32: {
                        LogicalStorage.get().authorizeAsSystem();
                        PGInvocationContext.get().setPaymentId(paymentId);
                        payment = this.getFromQueue(paymentId);
                        if (payment == null) {
                            log.warn("Payment: " + paymentId + " already processed");
                            response.setResponseCode(200);
                            response.setResponseText("[NOK]");
                            return;
                        }
                        if (!ClearParkHelper.checkOrder(request, payment, this.getConnector().getConfiguration(), isCertMode)) {
                            response.setResponseCode(200);
                            response.setResponseText("[NOK]");
                            PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                            return;
                        }
                        HandlerCompletePayment.process(request, payment, messages);
                        if (isCertMode) break block32;
                        switch (payment.getStatus()) {
                            case SUCCEEDED: {
                                this.paymentSucceeded(payment, messages);
                                break block33;
                            }
                            case FAILED: {
                                this.paymentFailed(payment, messages);
                                break block33;
                            }
                            default: {
                                throw new Exception("could not determine payment status");
                            }
                        }
                    }
                    if (ClearParkHelper.isCertModeCase(this.getConnector().getConfiguration(), "4", paymentId) && !ClearParkHelper.isCase4Ok()) {
                        response.setResponseText("[NOK]");
                        response.setResponseCode(200);
                        PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                        return;
                    }
                }
                response.setResponseText("[OK]");
                response.setResponseCode(200);
                PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
            }
            finally {
                lock.unlock();
            }
        }
        catch (Throwable t) {
            log.error("service failed", t);
            response.setResponseCode(500);
            response.setResponseText("[NOK]");
            PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, t);
        }
        finally {
            PGInvocationContext.get().end(this.getConnector(), pgLog);
            if (payment != null) {
                PGInvocationContext.get().saveDocs(pgLog, messages, payment.getPayee());
            }
            response.send();
            LogicalStorage.reset();
        }
        log.debug("service() END");
    }
}

