/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.clearpark;

import java.util.Properties;

class Configuration {
    private final boolean traceEnabled;
    private final String redirectUrl;
    private final Long queuePeriod;

    Configuration(Properties data) {
        this.traceEnabled = Configuration.isTrue(data.getProperty("trace.enabled"));
        this.redirectUrl = data.getProperty("redirect.url");
        this.queuePeriod = data.containsKey("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    boolean isValid() {
        return true;
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }
}

