/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.clearpark;

import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.server.pg.clearpark.ClearParkHelper;
import com.gridnine.xtrip.server.pg.clearpark.Configuration;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

class HandlerInitiatePayment {
    HandlerInitiatePayment() {
    }

    static void process(PaymentInitiationResult result, PaymentInitiationParameters parameters, PGParameters pgParameters, Configuration configuration) throws Exception {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat priceFormatter = new DecimalFormat("0.00", dfs);
        result.getRedirectForm().setUrl(configuration.getRedirectUrl());
        result.getRedirectForm().setMethod("POST");
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"CPID", (String)pgParameters.getPgAccount()));
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"ORDID", (String)parameters.getPayment().getPaymentId()));
        String equivalentCurrencyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"CURCODE", (String)equivalentCurrencyCode));
        String amount = priceFormatter.format(parameters.getPayment().getAmount().doubleValue());
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"TIA", (String)amount));
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"URLOK", (String)(parameters.getReturnUrl() + "&status=1")));
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"URLNOK", (String)(parameters.getReturnUrl() + "&status=0")));
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"LANG", (String)ClearParkHelper.getLanguage()));
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"PAYMENTSELECTION", (String)"CreditCard"));
    }
}

