/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.crediteurope;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.pg.cretideurope.CreditEuropeBankConfiguration;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreditEuropeHelper {
    private static final Logger log = Logger.getLogger(CreditEuropeHelper.class);

    static BigDecimal getTotalPrice(Payment payment, CreditEuropeBankConfiguration configuration, ContractType contractType) throws PGException {
        try {
            BigDecimal totalPrice = configuration.isTestingMode() ? BigDecimal.valueOf(configuration.getTestAmount().intValue()) : (BigDecimal)PaymentHelper.getTotalPrices((EntityReference)payment.getEntity(), (ContractType)contractType).get(payment.getPaymentType());
            return totalPrice;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw new PGException("Cannot get total price");
        }
    }

    static String getClientId(PGParameters pgParameters) {
        return pgParameters.getPgAccount().split(";")[0];
    }

    static String getUserName(PGParameters pgParameters) {
        return pgParameters.getPgAccount().split(";")[1];
    }

    static String getServiceApiName(PGParameters pgParameters) {
        return pgParameters.getPgAccount().split(";")[2];
    }

    static String getStorePassword(PGParameters pgParameters) {
        return pgParameters.getPgPassword().split(";")[0];
    }

    static String getServiceApiPassword(PGParameters pgParameters) {
        return pgParameters.getPgPassword().split(";")[1];
    }

    static void fillAuthData(PGParameters pgParameters, Document doc, Element cc5Request) {
        CreditEuropeHelper.addElement(doc, cc5Request, "Name", CreditEuropeHelper.getServiceApiName(pgParameters));
        CreditEuropeHelper.addElement(doc, cc5Request, "Password", CreditEuropeHelper.getServiceApiPassword(pgParameters));
        CreditEuropeHelper.addElement(doc, cc5Request, "ClientId", CreditEuropeHelper.getClientId(pgParameters));
    }

    static void addElement(Document doc, Element cc5Request, String name, String value) {
        Element nameElem = doc.createElement(name);
        XmlUtil.setValue((Element)nameElem, (String)value);
        cc5Request.appendChild(nameElem);
    }

    public static CreditEuropeBankConfiguration getConfiguration() {
        String CREDIT_EUROPE_BANK_CONFIGURATION_UID = "credit-europe-bank-configuration";
        EntityReference settingsRef = new EntityReference("credit-europe-bank-configuration", CreditEuropeBankConfiguration.class, null);
        EntityContainer result = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(settingsRef);
        if (result != null) {
            return (CreditEuropeBankConfiguration)result.getEntity();
        }
        CreditEuropeBankConfiguration newConfig = new CreditEuropeBankConfiguration();
        newConfig.setName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 Credit Europe Bank");
        newConfig.setType(SystemSettingsType.PG_CONFIGURATION);
        newConfig.setApiServiceUrl("https://entegrasyon.asseco-see.com.tr/fim/api");
        newConfig.setRedirectUrl("https://entegrasyon.asseco-see.com.tr/fim/est3Dgate");
        newConfig.setTestingMode(true);
        newConfig.setTestAmount(Integer.valueOf(10));
        newConfig.setPgName(PgName.CREDIT_EUROPE_BANK);
        EntityContainer container = EntityContainer.create((BaseEntity)newConfig);
        container.setUid("credit-europe-bank-configuration");
        container.setCreatedBy("system");
        container.getVersionInfo().setCreatedBy("system");
        EntityStorage.get().save(container, true);
        return newConfig;
    }

    static StringBuilder createParamsString(Map<String, String> paramMap) throws UnsupportedEncodingException {
        StringBuilder params = new StringBuilder();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (params.length() > 0) {
                params.append("&");
            }
            params.append(key + "=" + URLEncoder.encode(value.trim(), "UTF-8"));
        }
        return params;
    }

    private static SSLSocketFactory getFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("TLSv1");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }
        }};
        KeyManager[] managers = new KeyManager[]{new X509KeyManager(){

            @Override
            public String[] getServerAliases(String arg0, Principal[] arg1) {
                return null;
            }

            @Override
            public PrivateKey getPrivateKey(String arg0) {
                return null;
            }

            @Override
            public String[] getClientAliases(String arg0, Principal[] arg1) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String arg0) {
                return null;
            }

            @Override
            public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
                return null;
            }

            @Override
            public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
                return null;
            }
        }};
        sc.init(managers, trustAllCerts, new SecureRandom());
        return sc.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Element executeHttpConnection(Document requestData, CreditEuropeBankConfiguration configuration, PGParameters pgParameters, String traceRequestMethod) throws Exception {
        URL url = new URL(configuration.getApiServiceUrl());
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        StringBuilder serverResponse = new StringBuilder();
        try {
            StringBuilder params = new StringBuilder();
            params.append("DATA=" + URLEncoder.encode(XUtil.toString((Document)requestData), "UTF-8"));
            connection.setSSLSocketFactory(CreditEuropeHelper.getFactory());
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestProperty("charset", "utf-8");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Length", Integer.toString(params.toString().getBytes().length));
            DataOutputStream wr = null;
            try {
                wr = new DataOutputStream(connection.getOutputStream());
                wr.writeBytes(params.toString());
                wr.flush();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(wr);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)wr);
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                String readLine = in.readLine();
                while (readLine != null) {
                    if (serverResponse.length() > 0) {
                        serverResponse.append("\n");
                    }
                    serverResponse.append(readLine);
                    readLine = in.readLine();
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
            Element element = XUtil.fromBytes((byte[])serverResponse.toString().getBytes());
            PGInvocationContext.get().addTraceData(new Date(), traceRequestMethod, (Object)requestData.getDocumentElement(), (Object)element, null);
            return element;
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(new Date(), traceRequestMethod, null, null, (Throwable)e);
            log.error((Object)"Http connection error", (Throwable)e);
            throw e;
        }
    }
}

