/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.crediteurope;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.cretideurope.CreditEuropeBankConfiguration;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.crediteurope.CreditEuropeHelper;
import com.gridnine.xtrip.server.pg.crediteurope.HandlerCheckTransaction;
import com.gridnine.xtrip.server.pg.crediteurope.HandlerConfirmTransaction;
import com.gridnine.xtrip.server.pg.crediteurope.HandlerInitiatePayment;
import com.gridnine.xtrip.server.pg.crediteurope.HandlerRollbackTransaction;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CreditEuropePGConnector
extends PGConnector {
    static final String AUDIT_TAG_PREFIX = "crediteurope-pgconnector";
    private Tracer tracer;
    private boolean disposed;

    public PgName getId() {
        return PgName.CREDIT_EUROPE_BANK;
    }

    protected void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.tracer = PGHelper.createTracer((PgName)this.getId());
        this.log.debug("configured");
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_CREDIT_EUROPE_BANK);
        return result;
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        PaymentInitiationResult paymentInitiationResult;
        if (this.disposed) {
            throw new IllegalStateException("dispose");
        }
        Message auditMessage = null;
        Payment payment = parameters.getPayment();
        this.doPaymentReprice(payment);
        PGInvocationContext.get().begin(InvocationName.INITIATE_PAYMENT.toString());
        Date startDate = new Date();
        PGInvocationContext.get().setPaymentId(payment.getPaymentId());
        PaymentInitiationResult result = new PaymentInitiationResult();
        result.setPayment(payment);
        try {
            EntityContainer bookingFile = EntityStorage.get().resolve(payment.getEntity());
            PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)parameters.getSalesContext(), (PgName)parameters.getPg(), (Payment)payment);
            if (TextUtil.isBlank((String)pgParameters.getPgAccount())) {
                this.log.error(String.format("PgAccount isn't filled, salesPoint [%s]", parameters.getSalesContext().getSalesPoint().getCaption()));
                throw new PGException("PgAccount isn't filled");
            }
            HandlerInitiatePayment.process(result, parameters, pgParameters, this.getContractType(), (BookingFile)bookingFile.getEntity());
            this.paymentInitiated(result.getPayment(), result.getMessages());
            result.setSuccess(true);
            auditMessage = MessageHelper.createMessage((String)"initiate", (Object[])new Object[0]);
            result.getMessages().add(MessageHelper.createMessage((String)"\u041f\u043b\u0430\u0442\u0435\u0436 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d", (String)result.getPayment().getPaymentId(), (Object[])new Object[]{this.getId()}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, null);
            paymentInitiationResult = result;
        }
        catch (PGException ex) {
            this.log.error(String.format("payment [%s] initiation failed", this.getPaymentEntityCaption(parameters.getPayment())), (Throwable)ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            auditMessage = MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]);
            result.getMessages().add(auditMessage);
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, (Throwable)ex);
            PaymentInitiationResult paymentInitiationResult2 = result;
            PGInvocationContext.get().end((PGConnector)this, null);
            CreditEuropePGConnector.auditMessage((EntityReference)parameters.getPayment().getEntity(), (Message)auditMessage, (String)AUDIT_TAG_PREFIX);
            return paymentInitiationResult2;
        }
        catch (Throwable t) {
            this.log.error(String.format("payment [%s] initiation failed", this.getPaymentEntityCaption(parameters.getPayment())), t);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)t));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)"\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", (String)payment.getPaymentId(), (Object[])new Object[]{this.getId()}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, t);
            PaymentInitiationResult paymentInitiationResult3 = result;
            {
                catch (Throwable throwable) {
                    PGInvocationContext.get().end((PGConnector)this, null);
                    CreditEuropePGConnector.auditMessage((EntityReference)parameters.getPayment().getEntity(), auditMessage, (String)AUDIT_TAG_PREFIX);
                    throw throwable;
                }
            }
            PGInvocationContext.get().end((PGConnector)this, null);
            CreditEuropePGConnector.auditMessage((EntityReference)parameters.getPayment().getEntity(), (Message)auditMessage, (String)AUDIT_TAG_PREFIX);
            return paymentInitiationResult3;
        }
        PGInvocationContext.get().end((PGConnector)this, null);
        CreditEuropePGConnector.auditMessage((EntityReference)parameters.getPayment().getEntity(), (Message)auditMessage, (String)AUDIT_TAG_PREFIX);
        return paymentInitiationResult;
    }

    private String getPaymentEntityCaption(Payment payment) {
        String result = "unknown";
        try {
            result = payment.getEntity().getCaption();
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
        }
        return result;
    }

    protected Long getQueuePeriod() {
        return null;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        String transactionId = parameters.getPayment().getPgPaymentId();
        PaymentCheckResult result = new PaymentCheckResult();
        result.setSuccess(true);
        result.setPaymentStatus(PaymentStatus.SUCCEEDED);
        PGInvocationContext.get().begin(InvocationName.CHECK_PAYMENT.toString());
        Payment payment = null;
        if (this.log.isWarnEnabled()) {
            this.log.warn("Check transactionId: " + transactionId);
        }
        try (NamedLock lock = this.getLock(transactionId);){
            if (!lock.tryLock()) {
                String msg = String.format("Cannot lock transactionId [%s]", transactionId);
                this.log.error(msg);
                throw new PGException(msg);
            }
            Map<String, String> httpRequestParameters = this.getHttpRequestParameters(parameters);
            if (httpRequestParameters.size() > 0) {
                PGInvocationContext.get().addTraceData(new Date(), "http-request-parameters", httpRequestParameters, null, null);
            }
            try {
                payment = this.getFromQueue(transactionId);
                if (payment == null) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn(String.format("Thinks that the payment's processed [%s]", transactionId));
                    }
                    PaymentCheckResult paymentCheckResult = result;
                    return paymentCheckResult;
                }
                CreditEuropeBankConfiguration configuration = CreditEuropeHelper.getConfiguration();
                EntityContainer bookingFile = EntityStorage.get().resolve(payment.getEntity());
                String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFile.getEntity()));
                if (((BookingFile)bookingFile.getEntity()).getWorkflowStatus() == WorkflowStatus.PAYED) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(String.format("The booking file is already payed - stop processing the request [bookingNumber=%s]", bookingNumber));
                    }
                    PaymentCheckResult paymentCheckResult = result;
                    return paymentCheckResult;
                }
                PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)PaymentHelper.restoreSalesContext((Payment)payment), (PgName)this.getId(), (Payment)payment);
                try {
                    HandlerCheckTransaction.process(transactionId, this, configuration, pgParameters, payment, this.getContractType());
                }
                catch (Exception e) {
                    String msg = String.format("Payment checking wasn't successful [transactionId=%s]", transactionId);
                    this.log.error(msg);
                    result.setPaymentStatus(PaymentStatus.ERROR);
                    result.setSuccess(false);
                    Message message = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)msg, (Throwable)e, (Object[])new Object[0]);
                    result.getMessages().add(message);
                    PaymentCheckResult paymentCheckResult = result;
                    lock.unlock();
                    lock.close();
                    PGInvocationContext.get().end((PGConnector)this, null);
                    return paymentCheckResult;
                }
                LinkedList messages = new LinkedList();
                this.paymentSucceeded(payment, messages);
                bookingFile = EntityStorage.get().resolve(payment.getEntity());
                boolean allIssued = PaymentHelper.isAllIssued((BookingFile)((BookingFile)bookingFile.getEntity()));
                if (this.log.isTraceEnabled()) {
                    this.log.trace(String.format("Booking [%s], allIssued [%b]", bookingNumber, allIssued));
                }
                if (!allIssued) {
                    boolean hasSoldProducts = PaymentHelper.hasSoldProducts((BookingFile)((BookingFile)bookingFile.getEntity()));
                    if (this.log.isWarnEnabled()) {
                        this.log.warn(String.format("Booking [%s], allIssued [%b], hasSoldProducts [%b]", bookingNumber, allIssued, hasSoldProducts));
                    }
                    if (hasSoldProducts) {
                        this.log.error("Not all tickeds are issued " + bookingNumber);
                        throw new Exception("issuing failed");
                    }
                    result.setPaymentStatus(PaymentStatus.ERROR);
                    HandlerRollbackTransaction.process(transactionId, this, pgParameters, configuration, payment);
                } else {
                    HandlerConfirmTransaction.process(transactionId, payment, configuration, pgParameters, this.getContractType(), (BookingFile)bookingFile.getEntity());
                }
            }
            finally {
                lock.unlock();
            }
        }
        catch (Throwable t) {
            this.log.error("service failed", t);
            result.setSuccess(false);
            result.setPaymentStatus(PaymentStatus.ERROR);
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, null);
        }
        if (!this.log.isDebugEnabled()) return result;
        this.log.debug("service() END");
        return result;
    }

    private Map<String, String> getHttpRequestParameters(PaymentCheckParameters parameters) {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        List customParameters = parameters.getCustomParameters();
        for (NamedValue namedValue : customParameters) {
            String name = namedValue.getName();
            if (name.indexOf("request.parameter.") <= -1) continue;
            requestParameters.put(namedValue.getName(), namedValue.getValue());
        }
        return requestParameters;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }
}

