/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.crediteurope;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.cretideurope.CreditEuropeBankConfiguration;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.crediteurope.CreditEuropeHelper;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HandlerCheckTransaction {
    private static final Logger log = LoggerFactory.getLogger(HandlerCheckTransaction.class);

    public static void process(String transactionId, PGConnector connector, CreditEuropeBankConfiguration configuration, PGParameters pgParameters, Payment payment, ContractType contractType) throws PGException {
        Document doc = DocumentBuilderHelper.newDocument();
        Element cc5Request = doc.createElement("CC5Request");
        doc.appendChild(cc5Request);
        CreditEuropeHelper.fillAuthData(pgParameters, doc, cc5Request);
        CreditEuropeHelper.addElement(doc, cc5Request, "OrderId", payment.getPaymentId());
        Element extra = doc.createElement("Extra");
        cc5Request.appendChild(extra);
        CreditEuropeHelper.addElement(doc, extra, "ORDERSTATUS", "QUERY");
        try {
            Element result = CreditEuropeHelper.executeHttpConnection(doc, configuration, pgParameters, "checkTransaction");
            String response = XmlUtil.getValue((Element)result, (String)"Response");
            String transactionAmount = XmlUtil.getValue((Element)result, (String)"Extra/ORIG_TRANS_AMT");
            String transactionState = XmlUtil.getValue((Element)result, (String)"Extra/TRANS_STAT");
            boolean isCorrect = false;
            if ("Approved".equals(response) && "A".equals(transactionState)) {
                BigDecimal payedAmount;
                BigDecimal amount = CreditEuropeHelper.getTotalPrice(payment, configuration, contractType);
                if (amount.compareTo(payedAmount = new BigDecimal(transactionAmount).divide(BigDecimal.valueOf(100L))) == 0) {
                    isCorrect = true;
                } else {
                    log.error(String.format("Sums aren't correct, payed [%.2f], initiated [%.2f]", payedAmount, amount));
                }
            }
            if (!isCorrect) {
                throw new PGException("Incorrect transaction state");
            }
            Message auditMessage = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"check - ok", (Object[])new Object[0]);
            PGConnector.auditMessage((EntityReference)payment.getEntity(), (Message)auditMessage, (String)"crediteurope-pgconnector");
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(new Date(), InvocationName.GET_PAYMENT_INFO.toString(), null, null, (Throwable)e);
            String errorMsg = String.format("Transaction [%s] checking failed", transactionId);
            log.error(errorMsg, (Throwable)e);
            Message auditMessage = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"check failed", (Throwable)e, (Object[])new Object[0]);
            PGConnector.auditMessage((EntityReference)payment.getEntity(), (Message)auditMessage, (String)"crediteurope-pgconnector");
            throw new PGException("Transaction checking error", (Throwable)e);
        }
    }
}

