/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.crediteurope;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.cretideurope.CreditEuropeBankConfiguration;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.crediteurope.CreditEuropeHelper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HandlerConfirmTransaction {
    private static final Logger log = LoggerFactory.getLogger(HandlerConfirmTransaction.class);

    public static void process(String transactionId, Payment payment, CreditEuropeBankConfiguration configuration, PGParameters pgParameters, ContractType contractType, BookingFile bookingFile) {
        Document doc = DocumentBuilderHelper.newDocument();
        Element cc5Request = doc.createElement("CC5Request");
        CreditEuropeHelper.fillAuthData(pgParameters, doc, cc5Request);
        doc.appendChild(cc5Request);
        CreditEuropeHelper.addElement(doc, cc5Request, "Type", "PostAuth");
        CreditEuropeHelper.addElement(doc, cc5Request, "OrderId", payment.getPaymentId());
        Message message = null;
        try {
            Element result = CreditEuropeHelper.executeHttpConnection(doc, configuration, pgParameters, "confirmTransaction");
            String response = XmlUtil.getValue((Element)result, (String)"Response");
            if (!"Approved".equals(response)) {
                throw new PGException("Incorrect confirm response");
            }
            message = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"confirmation - ok", (Object[])new Object[0]);
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(new Date(), InvocationName.PAYMENT_CONFIRM.toString(), null, null, (Throwable)e);
            log.error("", (Throwable)e);
            message = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"confirmation failed", (Throwable)e, (Object[])new Object[0]);
        }
        PGConnector.auditMessage((EntityReference)payment.getEntity(), (Message)message, (String)"crediteurope-pgconnector");
    }
}

