/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.crediteurope;

import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.pg.cretideurope.CreditEuropeBankConfiguration;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.crediteurope.CreditEuropeHelper;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandlerInitiatePayment {
    private static final transient Logger log = LoggerFactory.getLogger(HandlerInitiatePayment.class);

    HandlerInitiatePayment() {
    }

    public static void process(PaymentInitiationResult result, PaymentInitiationParameters paymentInitiationParameters, PGParameters pgParameters, ContractType contractType, BookingFile bookingFile) throws Exception {
        CreditEuropeBankConfiguration configuration = CreditEuropeHelper.getConfiguration();
        Reservation baseProductReservation = BookingHelper.getBaseProductReservation((BookingFile)bookingFile);
        paymentInitiationParameters.getPayment().setPaymentId(TextUtil.translit((String)CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)baseProductReservation), (boolean)true));
        String clientId = CreditEuropeHelper.getClientId(pgParameters);
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"clientid", (String)clientId));
        String storekey = CreditEuropeHelper.getStorePassword(pgParameters);
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"storekey", (String)storekey));
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"currency", (String)"643"));
        String oid = paymentInitiationParameters.getPayment().getPaymentId();
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"oid", (String)oid));
        String okUrl = paymentInitiationParameters.getReturnUrl() + "&status=1";
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"okUrl", (String)okUrl));
        String failUrl = paymentInitiationParameters.getReturnUrl() + "&status=0";
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"failUrl", (String)failUrl));
        BigDecimal totalPrice = CreditEuropeHelper.getTotalPrice(paymentInitiationParameters.getPayment(), configuration, contractType);
        String amount = String.valueOf(totalPrice.intValueExact());
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"amount", (String)amount));
        String rnd = new Date().toString();
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"rnd", (String)rnd));
        String taksit = "";
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"taksit", (String)taksit));
        String islemtipi = "PreAuth";
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"islemtipi", (String)islemtipi));
        String hashstr = clientId + oid + amount + okUrl + failUrl + islemtipi + taksit + rnd + storekey;
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        String hash = Base64.encode((byte[])sha1.digest(hashstr.getBytes()));
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"hash", (String)hash));
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"lang", (String)"en"));
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"refreshtime", (String)"10"));
        result.getRedirectForm().setMethod("POST");
        result.getRedirectForm().setUrl(configuration.getRedirectUrl());
    }
}

