/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.crediteurope;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.cretideurope.CreditEuropeBankConfiguration;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.crediteurope.CreditEuropeHelper;
import com.gridnine.xtrip.server.pg.crediteurope.CreditEuropePGConnector;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HandlerRollbackTransaction {
    private static final Logger log = LoggerFactory.getLogger(HandlerRollbackTransaction.class);

    public static void process(String transactionId, CreditEuropePGConnector connector, PGParameters pgParameters, CreditEuropeBankConfiguration configuration, Payment payment) {
        Document doc = DocumentBuilderHelper.newDocument();
        Element cc5Request = doc.createElement("CC5Request");
        doc.appendChild(cc5Request);
        CreditEuropeHelper.fillAuthData(pgParameters, doc, cc5Request);
        CreditEuropeHelper.addElement(doc, cc5Request, "Type", "Void");
        CreditEuropeHelper.addElement(doc, cc5Request, "OrderId", payment.getPaymentId());
        Message message = null;
        try {
            Element result = CreditEuropeHelper.executeHttpConnection(doc, configuration, pgParameters, "cancelTransaction");
            String response = XmlUtil.getValue((Element)result, (String)"Response");
            if (!"Approved".equals(response)) {
                throw new PGException("Incorrect rollback response");
            }
            message = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"rollback - ok", (Object[])new Object[0]);
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(new Date(), "cancelTransaction", null, null, (Throwable)e);
            log.error("", (Throwable)e);
            message = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"rollback's failed", (Throwable)e, (Object[])new Object[0]);
        }
        PGConnector.auditMessage((EntityReference)payment.getEntity(), (Message)message, (String)"crediteurope-pgconnector");
    }
}

