/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.dskbank;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Configuration {
    protected static final transient Logger log = LoggerFactory.getLogger(Configuration.class);
    private final long checkerDelay;
    private final String merchantId;
    private final Integer paymentTimeout;
    private final Long queuePeriod;
    private final String serviceUrl;
    private final boolean testMode;
    private final boolean traceEnabled;
    private final double testAmount;
    private static final double DEFAULT_TEST_PAYMENT_AMOUNT = 10.0;

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }

    Configuration(Properties data) {
        double test;
        this.traceEnabled = Configuration.isTrue(data.getProperty("trace.enabled"));
        this.checkerDelay = data.containsKey("checker.delay") ? Long.parseLong(data.getProperty("checker.delay")) : 60000L;
        this.testMode = Configuration.isTrue(data.getProperty("test.enabled"));
        this.paymentTimeout = data.contains("payment.timeout") ? Integer.valueOf(data.getProperty("payment.timeout")) : Integer.valueOf(60);
        this.queuePeriod = data.contains("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
        this.serviceUrl = data.getProperty("service.url");
        this.merchantId = data.getProperty("merchant.id");
        if (data.getProperty("test.ammount") != null) {
            try {
                test = Double.parseDouble(data.getProperty("test.ammount"));
            }
            catch (NumberFormatException e) {
                test = 10.0;
            }
        } else {
            test = 10.0;
        }
        this.testAmount = test;
        if (log.isInfoEnabled()) {
            log.info(String.format("Use testMode[%s]", this.testMode));
            log.info(String.format("Use [%.2f] as a test payment amount", this.testAmount));
        }
    }

    public long getCheckerDelay() {
        return this.checkerDelay;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public Integer getPaymentTimeout() {
        return this.paymentTimeout;
    }

    public Long getQueuePeriod() {
        return this.queuePeriod;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    boolean isTest() {
        return this.testMode;
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    boolean isValid() {
        return !TextUtil.isBlank((String)this.serviceUrl);
    }

    double getTestAmmount() {
        return this.testAmount;
    }
}

