/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.dskbank;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.util.BinHex;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.dskbank.Configuration;
import com.gridnine.xtrip.server.pg.dskbank.ws.TransactionReportError;
import com.gridnine.xtrip.server.pg.dskbank.ws.TransactionReportItemExt;
import com.gridnine.xtrip.server.pg.dskbank.ws.TransactionReportReqExt;
import com.gridnine.xtrip.server.pg.dskbank.ws.TransactionReportResExt;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerCheckPayment {
    private static final transient Logger log = LoggerFactory.getLogger(HandlerCheckPayment.class);
    public static Set<Integer> successfulStatus = new HashSet<Integer>();
    public static Set<Integer> unsuccessfulStatus;
    public static Set<Integer> inProgressStatus;

    private static DateFormat createMd5DateFormat() {
        return new SimpleDateFormat("yyyyMMdd");
    }

    public static TransactionReportReqExt createRequest(PGParameters pgParameters, PaymentCheckParameters parameters) throws Exception {
        TransactionReportReqExt request = new TransactionReportReqExt();
        Payment payment = parameters.getPayment();
        EntityContainer bfCtr = EntityStorage.get().resolve(payment.getEntity());
        Date date = ((BookingFile)bfCtr.getEntity()).getCreateDate();
        request.setDate(date);
        request.setMerchantId(pgParameters.getPgAccount());
        request.setTrackId(payment.getPaymentId());
        String md5 = HandlerCheckPayment.getMd5Report(pgParameters.getPgAccount(), payment.getPaymentId(), date, pgParameters.getPgPassword());
        request.setMd5(md5);
        return request;
    }

    public static String getMd5Report(String merchantId, String trackId, Date date, String password) {
        StringBuilder textForMd5 = new StringBuilder();
        textForMd5.append(merchantId).append(trackId).append(HandlerCheckPayment.createMd5DateFormat().format(date)).append(password);
        log.debug("string for md5: " + textForMd5.toString());
        return HandlerCheckPayment.md5FormString(textForMd5.toString());
    }

    public static String md5FormString(String s) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(s.toString().getBytes(Charset.forName("UTF8")));
            byte[] resultByte = messageDigest.digest();
            return new String(BinHex.encode((byte[])resultByte));
        }
        catch (Exception e) {
            log.error("Error on creating md5 hash");
            return new String();
        }
    }

    static void processRepsonse(Payment payment, TransactionReportResExt response, List<Message> messages, Configuration configuration, BigDecimal totalOrderPrice) throws Exception {
        TransactionReportError error = response.getError();
        if (error.getErrorCode() != 0) {
            log.debug(response.getError().getErrorCode() + " - " + response.getError().getDescription());
            throw new PGException(error.getDescription());
        }
        List items = response.getTransactionReportItems().getItems().getTransactionReportItemExt();
        TransactionReportItemExt lastItem = null;
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            TransactionReportItemExt item;
            lastItem = item = (TransactionReportItemExt)iterator.next();
            log.debug("TransactionReportItem: " + item.getStatus() + " " + item.getDescription() + " " + item.getMerchantId() + " " + item.getPaymentType() + " " + item.getResult());
            if (successfulStatus.contains(lastItem.getStatus())) {
                payment.setStatus(PaymentStatus.SUCCEEDED);
                break;
            }
            if (unsuccessfulStatus.contains(lastItem.getStatus())) {
                payment.setStatus(PaymentStatus.FAILED);
                break;
            }
            payment.setStatus(PaymentStatus.IN_PROGRESS);
        }
        if (lastItem == null) {
            log.error("No TransactionReport for payment: " + payment.getPaymentId());
            throw new PGException("No TransactionReport for payment: " + payment.getPaymentId());
        }
        messages.add(HandlerCheckPayment.createMessageByStatus(lastItem.getStatus()));
        if (payment.getStatus() == PaymentStatus.SUCCEEDED) {
            HandlerCheckPayment.checkResult(payment, lastItem);
        }
        if (payment.getStatus() == PaymentStatus.SUCCEEDED) {
            HandlerCheckPayment.checkResponseCode(payment, lastItem);
        }
        if (payment.getStatus() == PaymentStatus.SUCCEEDED) {
            CardTransactionDetails details = new CardTransactionDetails();
            details.setSecurityCode(lastItem.getAuthCode());
            details.setTransactionCode(lastItem.getTransactionId());
            details.setNameOnCard(lastItem.getCardholderName());
            details.setNumber("XXXXXXXXXXXX" + lastItem.getLast4());
            payment.setDetails(details);
            payment.setAmount(new BigDecimal(lastItem.getAmount()).round(MathContext.DECIMAL32));
            if (configuration.isTest()) {
                payment.setAmount(totalOrderPrice);
            }
        }
    }

    private static Message createMessageByStatus(Integer paymentStatus) {
        String text = null;
        switch (paymentStatus) {
            case 0: {
                text = "Payment inquiry is received from the merchant, but the request is still not sent to ACI Commerce Gateway";
                break;
            }
            case 1: {
                text = "Error during 3DS authentication";
                break;
            }
            case 2: {
                text = "The issuer does not authenticate the cardholder for 3DS authentication";
                break;
            }
            case 3: {
                text = "The card payment is completed successfully (whether a 3D Secure authentication has been made or not)";
                break;
            }
            case 4: {
                text = "Communicational problem";
                break;
            }
            case 5: {
                text = "The payment authorization has been rejected\u0430";
                break;
            }
            case 6: {
                text = "In progress";
                break;
            }
            case 7: {
                text = "The customer has reached the eCommerce site, but has not started a payment";
                break;
            }
            case 8: {
                text = "Canceled by the user (the user has chosen Cancel button)";
                break;
            }
            case 9: {
                text = "Error at the validations in eCommerce. Error description is provided in the field error_code";
                break;
            }
            case 10: {
                text = "DSK Direct payment is created; not sent to the bank system";
                break;
            }
            case 11: {
                text = "Successful DSK Direct payment.";
                break;
            }
            case 12: {
                text = "Unsuccessful DSK Direct payment";
                break;
            }
            case 13: {
                text = "Locked DSK Direct payment; the Merchant should contact DSK Bank.";
                break;
            }
            default: {
                text = String.format("unknown payment status %s", text);
            }
        }
        if (unsuccessfulStatus.contains(paymentStatus)) {
            return MessageHelper.createErrorMessage((String)text, (Object[])new Object[0]);
        }
        return MessageHelper.createMessage((String)text, (Object[])new Object[0]);
    }

    private static void checkResult(Payment payment, TransactionReportItemExt item) {
        String result = item.getResult();
        if ("CAPTURED".equals(result)) {
            payment.setStatus(PaymentStatus.SUCCEEDED);
        } else if ("NOT CAPTURED".equals(result)) {
            payment.setStatus(PaymentStatus.FAILED);
        }
        log.debug("TransactionReport Result - " + item.getResult());
    }

    private static void checkResponseCode(Payment payment, TransactionReportItemExt item) {
        String responseCode = item.getResponseCode();
        if ("00".equals(responseCode)) {
            payment.setStatus(PaymentStatus.SUCCEEDED);
        } else if ("D0".equals(responseCode)) {
            payment.setStatus(PaymentStatus.IN_PROGRESS);
        } else if ("D1".equals(responseCode)) {
            payment.setStatus(PaymentStatus.SUCCEEDED);
        } else {
            payment.setStatus(PaymentStatus.FAILED);
        }
        log.debug("TransactionReport ResponseCode - " + responseCode);
    }

    static {
        successfulStatus.add(3);
        successfulStatus.add(11);
        unsuccessfulStatus = new HashSet<Integer>();
        successfulStatus.add(1);
        successfulStatus.add(2);
        successfulStatus.add(4);
        successfulStatus.add(5);
        successfulStatus.add(8);
        successfulStatus.add(9);
        successfulStatus.add(12);
        inProgressStatus = new HashSet<Integer>();
        successfulStatus.add(0);
        successfulStatus.add(6);
        successfulStatus.add(7);
        successfulStatus.add(10);
        successfulStatus.add(13);
    }
}

