/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.dskbank;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.dskbank.Configuration;
import com.gridnine.xtrip.server.pg.dskbank.HandlerCheckPayment;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandlerInitiatePayment {
    protected static final transient Logger log = LoggerFactory.getLogger(HandlerInitiatePayment.class);
    private static DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
    private static final DecimalFormat priceFormatter = new DecimalFormat("0.00", dfs);

    HandlerInitiatePayment() {
    }

    private static DateFormat createDateFormat() {
        return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    }

    public static void process(PaymentInitiationResult result, PaymentInitiationParameters parameters, PGParameters pgParameters, Configuration configuration) throws Exception {
        Payment payment = parameters.getPayment();
        payment.setPaymentId(payment.getPaymentId().replaceAll("-", "").substring(0, 10));
        if (pgParameters.getPgRedirectUrl() == null || TextUtil.isBlank((String)pgParameters.getPgRedirectUrl().toString())) {
            throw new PGException("Redirect Url isn't filled in the SalePoint");
        }
        result.getRedirectForm().setUrl(pgParameters.getPgRedirectUrl().toString());
        result.getRedirectForm().setMethod("POST");
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("merchant_id", pgParameters.getPgAccount()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("currency_code", "BGN"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("track_id", payment.getPaymentId()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("description", payment.getDescription()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("amount", priceFormatter.format(HandlerInitiatePayment.getPaymentAmmount(parameters, configuration))));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("payment_timeout", configuration.getPaymentTimeout().toString()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("ok_return_url", parameters.getReturnUrl() + "&status=1"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("cancel_return_url", parameters.getReturnUrl() + "&status=0"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("is_unique", "true"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("language", HandlerInitiatePayment.getLanguage()));
        EntityContainer bfCtr = EntityStorage.get().resolve(payment.getEntity());
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("merchant_timestamp", HandlerInitiatePayment.createDateFormat().format(((BookingFile)bfCtr.getEntity()).getCreateDate())));
        HandlerInitiatePayment.addHeaderAndMac(pgParameters, result, configuration);
    }

    static String getCarrierName(DictionaryReference<Airline> carrier) {
        return (String)MiscUtil.findByLocale((Map)((Airline)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(carrier)).getTranslations(), (Locale)Locale.ENGLISH);
    }

    private static void addHeaderAndMac(PGParameters pgParameters, PaymentInitiationResult result, Configuration configuration) throws Exception {
        StringBuilder params;
        StringBuilder lengths;
        StringBuilder header;
        if (pgParameters.getPgPassword() != null && !pgParameters.getPgPassword().isEmpty()) {
            DecimalFormat macFormatter1 = new DecimalFormat("00", dfs);
            DecimalFormat macFormatter2 = new DecimalFormat("000", dfs);
            header = new StringBuilder();
            lengths = new StringBuilder();
            params = new StringBuilder();
            List namedValues = result.getRedirectForm().getParameters();
            header.append(macFormatter1.format(namedValues.size()));
            for (int i = 0; i < namedValues.size(); ++i) {
                NamedValue namedValue = (NamedValue)namedValues.get(i);
                header.append(((NamedValue)namedValues.get(i)).getName());
                lengths.append(macFormatter2.format(namedValue.getValue().length()));
                header.append(",");
                params.append(namedValue.getValue());
            }
        } else {
            throw new PGException("Can't get PgPassword");
        }
        header.append((CharSequence)lengths);
        StringBuilder macText = new StringBuilder();
        macText.append((CharSequence)header).append((CharSequence)params).append(pgParameters.getPgPassword());
        String md5 = HandlerCheckPayment.md5FormString(macText.toString());
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("header", header.toString()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("mac", md5));
    }

    private static double getPaymentAmmount(PaymentInitiationParameters parameters, Configuration configuration) {
        if (configuration.isTest()) {
            return configuration.getTestAmmount();
        }
        return parameters.getPayment().getAmount().doubleValue();
    }

    static String getLanguage() {
        Locale loc = ((LocaleManager)Environment.getPublished(LocaleManager.class)).getCurrentLocale();
        String language = loc.getLanguage().toUpperCase();
        if ("BG".equals(language)) {
            return "bg-BG";
        }
        return "en-US";
    }

    private static NamedValue namedValue(String name, String value) {
        NamedValue nv = new NamedValue();
        nv.setName(name);
        nv.setValue(value);
        return nv;
    }
}

