/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ecommercyconnect;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.pg.ecommercyconnect.EcommercyConnectPgSettings;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PgConfigurationCompaundKeyProvider;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class EcommercyConnectHelper {
    public static final String RETURN_URL_PARAM_NAME = "return-url-param";
    public static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("yyMMddHHmmssZ");

    public static EntityContainer<EcommercyConnectPgSettings> getSettingsCtr() {
        EntityContainer ctr = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)PgConfigurationCompaundKeyProvider.getCompaundKey((PgName)PgName.ECOMMERCY_CONNECT));
        return ctr;
    }

    public static String getConfigDir() {
        return Environment.getConfigurationFolder() + "/pg/ECOMMERCY_CONNECT/";
    }

    public static String getReturnUrl(String baseUrl, boolean isSuccess) {
        if (TextUtil.isBlank((String)baseUrl)) {
            return null;
        }
        return baseUrl + "&status=" + (isSuccess ? "1" : "0");
    }

    public static String convertAmount2Str(BigDecimal amount) {
        if (amount == null) {
            return null;
        }
        return String.valueOf(amount.multiply(BigDecimal.valueOf(100L)).intValue());
    }

    public static String convertDate(ZonedDateTime date) {
        return date.format(DTF);
    }
}

