/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ecommercyconnect;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.ecommercyconnect.EcommercyConnectPgSettings;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.ecommercyconnect.EcommercyConnectHelper;
import java.util.HashMap;
import java.util.Map;

public class EcommercyConnectPGConnector
extends PGConnector {
    private boolean disposed;
    private Tracer tracer;

    public PgName getId() {
        return PgName.ECOMMERCY_CONNECT;
    }

    public boolean isEnabled() {
        EntityContainer<EcommercyConnectPgSettings> settingsCtr = EcommercyConnectHelper.getSettingsCtr();
        if (settingsCtr == null) {
            return false;
        }
        EcommercyConnectPgSettings settings = (EcommercyConnectPgSettings)settingsCtr.getEntity();
        return settings.isActive();
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.ECOMMERCY_CONNECT_CREDIT_CARD);
        return result;
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS.name(), parameters);
        data.put(IBusPgContextKeys.PG_CONNECTOR.name(), (Object)this);
        parameters.setDontDoReprice(true);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("pg-connector:initiate-payment-route", data);
        PaymentInitiationResult response = (PaymentInitiationResult)data.get(IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS.name());
        return response;
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters, Map<String, Object> ctx) {
        throw new UnsupportedOperationException();
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    public void configure(PGConnectorRegistry registry) {
        this.tracer = PGHelper.createTracer((PgName)this.getId());
    }
}

