/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ecommercyconnect;

import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.ecommercyconnect.EcommercyConnectPgSettings;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.ecommercyconnect.EcommercyConnectHelper;
import com.gridnine.xtrip.server.pg.trace.ExceptionItem;
import com.gridnine.xtrip.server.pg.trace.HttpRequestItem;
import com.gridnine.xtrip.server.pg.trace.ServletResponseItem;
import com.gridnine.xtrip.server.pg.trace.StepItem;
import com.gridnine.xtrip.server.pg.trace.TraceLog;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcommercyConnectPGServlet
extends PGServlet {
    private static final long serialVersionUID = -3694655557374307984L;
    private static final Logger log = LoggerFactory.getLogger(EcommercyConnectPGServlet.class);

    protected PgName getId() {
        return PgName.ECOMMERCY_CONNECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String responseText;
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            response.getWriter().write("service is ready");
            return;
        }
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            response.getWriter().write("method " + request.getMethod() + " is unsupported");
            return;
        }
        log.debug("service() BEGIN");
        TraceLog traceLog = new TraceLog("NOTIFY");
        String body = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
        HttpRequestItem item = new HttpRequestItem(request);
        item.setBody(body);
        traceLog.addStep((StepItem)item);
        Map<String, String> requestParams = this.convertParamsToMap(body);
        HashMap<String, String> responseParams = this.initResponseParams(requestParams);
        PGServletResponse pgResponse = new PGServletResponse(response);
        pgResponse.setResponseCode(200);
        ArrayList messages = new ArrayList();
        String baseReturnUrl = null;
        Payment payment = null;
        try {
            if (!this.isValidSignature(requestParams)) {
                throw new Exception("invalid signature");
            }
            this.authorizeLogicalStorage();
            String paymentId = requestParams.get("SD");
            payment = this.getFromQueue(paymentId);
            if (payment == null) {
                throw new Exception("payment " + paymentId + " already processed or not found");
            }
            baseReturnUrl = NamedValueHelper.getValueForName((String)"return-url-param", (Collection)payment.getCustomParameters());
            this.checkParams(requestParams, payment);
            boolean isOk = "000".equals(requestParams.get("TranCode"));
            if (isOk) {
                SalesContext salesContext = PaymentHelper.restoreSalesContext((Payment)payment);
                EntityContainer bookingCtr = PaymentHelper.getBookingFileContainer((Payment)payment);
                this.getConnector().paymentSucceeded(payment, messages, salesContext, bookingCtr);
                responseParams.put("Response.action", "approve");
                responseParams.put("Response.forwardUrl", EcommercyConnectHelper.getReturnUrl(baseReturnUrl, true));
                SysLogHelper.audit((EntityReference)payment.getEntity(), (String)"ecommercyconnect-servlet", (MessageType)MessageType.MESSAGE, (String[])new String[]{"\u041e\u043f\u043b\u0430\u0442\u0430 \u0432 \u041f\u0428 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0430"});
            } else {
                SysLogHelper.audit((EntityReference)payment.getEntity(), (String)"ecommercyconnect-servlet", (MessageType)MessageType.MESSAGE, (String[])new String[]{"\u041e\u043f\u043b\u0430\u0442\u0430 \u0432 \u041f\u0428 \u043d\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0430"});
                this.getConnector().paymentFailed(payment, messages);
                responseParams.put("Response.forwardUrl", EcommercyConnectHelper.getReturnUrl(baseReturnUrl, false));
            }
            responseText = responseParams.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("\n"));
        }
        catch (Throwable t) {
            String responseText2;
            try {
                log.error("service failed", t);
                responseParams.put("Response.action", "reverse");
                responseParams.put("Response.reason", t.getMessage());
                responseParams.put("Response.forwardUrl", EcommercyConnectHelper.getReturnUrl(baseReturnUrl, false));
                traceLog.addStep((StepItem)new ExceptionItem(t));
                if (payment != null) {
                    SysLogHelper.audit((EntityReference)payment.getEntity(), (String)"ecommercyconnect-servlet", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0438\u0437 \u041f\u0428", (Throwable)t, (Object[])new Object[0])});
                }
                responseText2 = responseParams.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("\n"));
            }
            catch (Throwable throwable) {
                String responseText3 = responseParams.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("\n"));
                if (pgResponse.getResponseText() == null) {
                    pgResponse.setResponseText(responseText3);
                }
                pgResponse.send();
                LogicalStorage.reset();
                traceLog.addStep((StepItem)new ServletResponseItem(pgResponse));
                this.getTracer().trace(new TraceItem[]{traceLog.toTraceItem()});
                throw throwable;
            }
            if (pgResponse.getResponseText() == null) {
                pgResponse.setResponseText(responseText2);
            }
            pgResponse.send();
            LogicalStorage.reset();
            traceLog.addStep((StepItem)new ServletResponseItem(pgResponse));
            this.getTracer().trace(new TraceItem[]{traceLog.toTraceItem()});
        }
        if (pgResponse.getResponseText() == null) {
            pgResponse.setResponseText(responseText);
        }
        pgResponse.send();
        LogicalStorage.reset();
        traceLog.addStep((StepItem)new ServletResponseItem(pgResponse));
        this.getTracer().trace(new TraceItem[]{traceLog.toTraceItem()});
    }

    private Map<String, String> convertParamsToMap(String body) throws UnsupportedEncodingException {
        if (TextUtil.isBlank((String)body)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String part : body.replaceAll("[\r\n]", "").split("&")) {
            String[] pair = part.split("=", 2);
            String key = pair[0];
            String value = pair.length > 1 ? pair[1] : null;
            result.put(this.urlDecode(key), this.urlDecode(value));
        }
        return result;
    }

    private String urlDecode(String value) throws UnsupportedEncodingException {
        return URLDecoder.decode(value, "utf-8");
    }

    private HashMap<String, String> initResponseParams(Map<String, String> requestParams) {
        List<String> fields = Arrays.asList("MerchantID", "TerminalID", "OrderID", "Currency", "TotalAmount", "XID", "PurchaseTime");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String field : fields) {
            String value = MiscUtil.guarded((String)requestParams.get(field));
            result.put(field, value);
        }
        return result;
    }

    private boolean isValidSignature(Map<String, String> params) throws Exception {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        String path = EcommercyConnectHelper.getConfigDir() + ((EcommercyConnectPgSettings)EcommercyConnectHelper.getSettingsCtr().getEntity()).getCrtFileName();
        Certificate certificate = factory.generateCertificate(new FileInputStream(path));
        PublicKey publicKey = certificate.getPublicKey();
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initVerify(publicKey);
        byte[] messageBytes = this.buildSignData(params).getBytes();
        signature.update(messageBytes);
        String sign = params.get("Signature");
        byte[] receivedSignature = new Base64().decode(sign);
        return signature.verify(receivedSignature);
    }

    private String buildSignData(Map<String, String> map) {
        List<String> fields = Arrays.asList("MerchantID", "TerminalID", "PurchaseTime", "OrderID", "XID", "Currency", "TotalAmount", "SD", "TranCode", "ApprovalCode");
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            String value = MiscUtil.guarded((String)map.get(field));
            sb.append(value).append(";");
        }
        return sb.toString();
    }

    private void checkParams(Map<String, String> requestParams, Payment payment) throws Exception {
        String totalAmount;
        String reqTotalAmount = requestParams.get("TotalAmount");
        if (!MiscUtil.equals((Object)reqTotalAmount, (Object)(totalAmount = EcommercyConnectHelper.convertAmount2Str(payment.getAmount())))) {
            throw new Exception("Invalid TotalAmount");
        }
    }
}

