/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ecommercyconnect.initiate;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.ecommercyconnect.EcommercyConnectPgSettings;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.RedirectForm;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.ecommercyconnect.EcommercyConnectHelper;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.net.util.Base64;

public class UpdatePaymentInitiationResultProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer settingsCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_SETTINGS);
        PaymentInitiationParameters params = (PaymentInitiationParameters)ctx.getMandatoryObject((Enum)IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        PGParameters pgParams = (PGParameters)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.SALES_POINT_PG_PARAMETERS);
        EcommercyConnectPgSettings settings = (EcommercyConnectPgSettings)settingsCtr.getEntity();
        PaymentInitiationResult resultParams = (PaymentInitiationResult)ctx.getMandatoryObject((Enum)IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS);
        RedirectForm redirectForm = resultParams.getRedirectForm();
        redirectForm.setUrl(settings.getServiceUrl());
        redirectForm.setMethod("POST");
        redirectForm.getParameters().addAll(this.prepareParams(pgParams, params, settings, (EntityContainer<BookingFile>)bookingFile));
        resultParams.getPayment().getCustomParameters().add(NamedValueHelper.namedValue((String)"return-url-param", (String)params.getReturnUrl()));
    }

    public List<NamedValue> prepareParams(PGParameters pgParameters, PaymentInitiationParameters parameters, EcommercyConnectPgSettings settings, EntityContainer<BookingFile> bookingCtr) throws Exception {
        String accountStr = pgParameters.getPgAccount();
        String[] accountData = accountStr.split(";");
        Payment payment = parameters.getPayment();
        BigDecimal amount = payment.getAmount();
        Locale preferredLocale = (Locale)MiscUtil.guarded((Object)payment.getCustomerInfo().getPreferredLocale(), (Object)LocaleHelper.getCurrentLocale());
        BookingFile booking = (BookingFile)bookingCtr.getEntity();
        BaseProduct firstProduct = (BaseProduct)((Reservation)booking.getReservations().get(0)).getProducts().get(0);
        GeneralProductContractRelationData contractRelation = GeneralProductHelper.getContractRelation((BaseProduct)firstProduct, (ContractType)ContractType.CLIENT);
        DictionaryReference currencyRef = GeneralProductHelper.getCurrency((BaseContractRelationData)contractRelation);
        CurrencyInfo currencyInfo = (CurrencyInfo)DictionaryCache.get().resolveReference(currencyRef);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Version", "1");
        map.put("MerchantID", accountData[0]);
        map.put("TerminalID", accountData[1]);
        map.put("TotalAmount", EcommercyConnectHelper.convertAmount2Str(amount));
        map.put("Currency", DictHelper.getCodeVariant((BaseDictionary)currencyInfo, (CodeSystem)CodeSystem.ISO_NUMERIC));
        map.put("locale", preferredLocale.getLanguage());
        map.put("PurchaseTime", EcommercyConnectHelper.convertDate(ZonedDateTime.now()));
        map.put("OrderID", booking.getNumber());
        map.put("SD", payment.getPaymentId());
        map.put("PurchaseDesc", payment.getDescription());
        String signData = this.buildSignData(map);
        map.put("Signature", this.buildSignature(signData, accountData, pgParameters.getPgPassword()));
        List<NamedValue> result = map.entrySet().stream().map(entry -> NamedValueHelper.namedValue((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList());
        return result;
    }

    private String buildSignData(Map<String, String> map) {
        List<String> fields = Arrays.asList("MerchantID", "TerminalID", "PurchaseTime", "OrderID", "Currency", "TotalAmount", "SD");
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            String value = MiscUtil.guarded((String)map.get(field));
            sb.append(value).append(";");
        }
        return sb.toString();
    }

    private String buildSignature(String signData, String[] accountData, String pgPsw) throws Exception {
        String p12FileName = accountData[2];
        String p12alias = accountData[3];
        String path = EcommercyConnectHelper.getConfigDir() + p12FileName;
        File p12File = new File(path);
        char[] p12psw = pgPsw.toCharArray();
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(new FileInputStream(p12File), p12psw);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(p12alias, p12psw);
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initSign(privateKey);
        signature.update(signData.getBytes());
        byte[] sign = signature.sign();
        return new Base64(64).encodeToString(sign);
    }
}

