/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.gateline;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.pg.SplitPaymentSupport;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.util.Collection;
import java.util.HashMap;

public class GatelinePGConnector
extends PGConnector
implements SplitPaymentSupport {
    public PgName getId() {
        return PgName.GATELINE;
    }

    protected void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.log.debug("configured");
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.GATELINE_CREDIT_CARD);
        result.getSupportedPaymentTypes().add(this.getSplitMainPaymentType());
        return result;
    }

    public void dispose() {
        this.log.debug("disposed");
    }

    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS.name(), parameters);
        data.put(IBusPgContextKeys.PG_CONNECTOR.name(), (Object)this);
        parameters.setDontDoReprice(true);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("pg-connector:initiate-payment-route", data);
        PaymentInitiationResult response = (PaymentInitiationResult)data.get(IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS.name());
        return response;
    }

    protected Long getQueuePeriod() {
        return null;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS.name(), parameters);
        data.put(IBusPgContextKeys.PG_CONNECTOR.name(), (Object)this);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("pg-connector:check-payment-route", data);
        PaymentCheckResult response = (PaymentCheckResult)data.get(IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS.name());
        return response;
    }

    protected Tracer getTracer() {
        return null;
    }

    public PaymentType getSplitMainPaymentType() {
        return PaymentType.GATELINE_CREDIT_CARD_SPLIT;
    }

    public PaymentType getSplitSupplierPaymentType() {
        return PaymentType.GATELINE_CREDIT_CARD_SUPPLIER;
    }

    public PaymentType getSplitAgencyPaymentType() {
        return PaymentType.GATELINE_CREDIT_CARD_AGENCY;
    }

    public boolean canUseSplitScheme(EntityContainer<BookingFile> bfCtr) throws Exception {
        boolean canUseSplitScheme = PaymentHelper.canUseSplitScheme((BookingFile)((BookingFile)bfCtr.getEntity()));
        return canUseSplitScheme;
    }

    public boolean canUseSplitScheme(Collection<Reservation> reservations) {
        if (reservations.size() != 1) {
            return false;
        }
        return PaymentHelper.canUseSplitScheme((Reservation)reservations.iterator().next());
    }
}

