/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.gateline;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.gateline.GatelinePgSettings;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatelinePgHelper {
    private static final transient Logger log = LoggerFactory.getLogger(GatelinePgHelper.class);

    public static StringBuilder createParamsString(Map<String, String> paramMap) throws UnsupportedEncodingException {
        StringBuilder params = new StringBuilder();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (params.length() > 0) {
                params.append("&");
            }
            params.append(key + "=" + URLEncoder.encode(value, "UTF-8"));
        }
        return params;
    }

    public static BigDecimal getTotalPrice(Payment payment, GatelinePgSettings settings, ContractType contractType, EntityContainer<BookingFile> bookingFile, Collection<Reservation> reservations) throws PGException {
        try {
            PaymentType paymentType = payment.getPaymentType();
            boolean canUseTestSums = settings.isTestingMode() && paymentType != PaymentType.GATELINE_CREDIT_CARD_SPLIT;
            return canUseTestSums ? BigDecimal.valueOf(settings.getTestAmount().intValue()) : (BigDecimal)PaymentHelper.getTotalPrices(bookingFile, reservations, (ContractType)contractType).get(paymentType);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PGException("Cannot get total price", (Throwable)e);
        }
    }

    public static DecimalFormat getDecimalFormat() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat priceFormat = new DecimalFormat("0.00", dfs);
        return priceFormat;
    }
}

