/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.gateline.check;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.gateline.IBusPGGatelineContextKeys;
import com.gridnine.xtrip.server.pg.gateline.check.PgSplitGdsCheckException;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import com.gridnine.xtrip.server.pg.split.SplitPaymentHelper;
import org.w3c.dom.Element;

public class CheckResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        HttpResponse response = (HttpResponse)ctx.getMandatoryObject(IBusHttpContextKeys.HTTP_RESPONSE.name());
        if (response.getResponseCode() != 200) {
            throw Xeption.forAdmin((String)("Invalid response code " + response.getResponseCode()), (Object[])new Object[0]);
        }
        Element element = XUtil.fromBytes((byte[])response.getBody());
        this.checkOrderStatus(element);
        String status = XmlUtil.getValue((Element)XmlUtil.getElement((Element)element, (String)"/export/order/status"));
        ctx.putObject((Enum)IBusPGGatelineContextKeys.GATELINE_CHECK_PAYMENT_STATUS, (Object)status);
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        if (payment.getPaymentType() == PaymentType.GATELINE_CREDIT_CARD_SPLIT) {
            this.checkGdsStatus(element);
            String authCode = this.getAuthCode(element);
            EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
            SplitPaymentHelper.saveApprovalCodeRemark((EntityContainer)bookingFile, (Payment)payment, (String)authCode);
        }
    }

    void checkGdsStatus(Element element) {
        String gdsStatus = XmlUtil.getValue((Element)XmlUtil.getElement((Element)element, (String)"/export/order/gds/status"));
        String SUCCESS_STATUS = "success";
        if (!"success".equals(gdsStatus)) {
            throw new PgSplitGdsCheckException(String.format("invalid reservation system status [%s], expected [%s]", gdsStatus, "success"));
        }
    }

    String getAuthCode(Element element) {
        Element[] elements;
        for (Element operation : elements = XmlUtil.getElements((Element)element, (String)"/export/order/operations/operation")) {
            String authCode;
            String operationType = XmlUtil.getValue((Element)XmlUtil.getElement((Element)operation, (String)"type"));
            String status = XmlUtil.getValue((Element)XmlUtil.getElement((Element)operation, (String)"status"));
            if (!"authorize".equals(operationType) || !"success".equals(status) || TextUtil.isBlank((String)(authCode = XmlUtil.getValue((Element)XmlUtil.getElement((Element)operation, (String)"authcode"))))) continue;
            return authCode;
        }
        throw Xeption.forAdmin((String)"Reservation system auth code not found", (Object[])new Object[0]);
    }

    void checkOrderStatus(Element element) {
        String status = XmlUtil.getValue((Element)XmlUtil.getElement((Element)element, (String)"/export/order/status"));
        String AUTH_STATUS = "authorize";
        if (!"authorize".equals(status)) {
            throw Xeption.forAdmin((String)String.format("invalid order status [%s], expected [%s]", status, "authorize"), (Object[])new Object[0]);
        }
    }
}

