/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.gateline.confirm;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.pg.gateline.GatelinePgSettings;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.LongRecordBuilder;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.gateline.GatelinePgHelper;
import com.gridnine.xtrip.server.pg.gateline.IBusPGGatelineContextKeys;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import com.gridnine.xtrip.server.pg.split.SplitPaymentHelper;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ConfirmRequestBuilder
extends BaseProcessor {
    private static final String OPERATION = "order/%s/settle";

    public void process(MessageContext ctx) throws Exception {
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        String getOperation = String.format(OPERATION, payment.getPgPaymentId());
        HashMap<String, String> requestParams = new HashMap<String, String>();
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        GatelinePgSettings settings = (GatelinePgSettings)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_SETTINGS);
        Collection reservations = PaymentHelper.getReservations((EntityContainer)bookingFile, (Collection)payment.getReservations());
        BigDecimal totalPrice = this.calculateTotalPrice(payment, (EntityContainer<BookingFile>)bookingFile, reservations, settings);
        if (payment.getPaymentType() == PaymentType.GATELINE_CREDIT_CARD_SPLIT) {
            this.handleSplitPayment(requestParams, reservations, totalPrice);
        } else {
            this.handlerCommonPayment(payment, requestParams, totalPrice);
        }
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)this.createHttpRequest(settings, getOperation, requestParams));
        ctx.putObject((Enum)IBusPGGatelineContextKeys.OPERATION, (Object)getOperation);
        ctx.putObject((Enum)IBusPGGatelineContextKeys.REQUEST_PARAMETERS, requestParams);
    }

    protected BigDecimal calculateTotalPrice(Payment payment, EntityContainer<BookingFile> bookingFile, Collection<Reservation> reservations, GatelinePgSettings settings) {
        return GatelinePgHelper.getTotalPrice(payment, settings, ContractType.CLIENT, bookingFile, reservations);
    }

    private void handlerCommonPayment(Payment payment, Map<String, String> requestParams, BigDecimal totalPrice) throws Exception {
        String longrecord = this.buildLongRecord(payment);
        if (longrecord != null) {
            requestParams.put("longrecord", longrecord);
        }
        requestParams.put("amount", GatelinePgHelper.getDecimalFormat().format(totalPrice));
    }

    protected String buildLongRecord(Payment payment) throws Exception {
        return new LongRecordBuilder().build(payment);
    }

    private void handleSplitPayment(Map<String, String> requestParams, Collection<Reservation> reservations, BigDecimal totalPrice) {
        BigDecimal commission = SplitPaymentHelper.getSplitPaymentCommisionPartAmount(reservations, (BigDecimal)totalPrice);
        requestParams.put("amount", GatelinePgHelper.getDecimalFormat().format(commission));
    }

    private HttpRequest createHttpRequest(GatelinePgSettings result, String getOperation, Map<String, String> requestParams) throws UnsupportedEncodingException {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUseTrustfulHostnameVerifier(true);
        httpRequest.setUseTrustfulManager(false);
        httpRequest.setRequestMethod(RequestMethod.POST);
        httpRequest.setUrl(result.getServiceUrl() + getOperation);
        httpRequest.setBody(GatelinePgHelper.createParamsString(requestParams).toString().getBytes());
        return httpRequest;
    }
}

