/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.gateline.core;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.gateline.IBusPGGatelineContextKeys;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;

public class AuthHeaderProcessor
extends BaseProcessor {
    private static final X509TrustManager trustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };

    public void process(MessageContext ctx) throws Exception {
        String operation = (String)ctx.getMandatoryObject((Enum)IBusPGGatelineContextKeys.OPERATION);
        HttpRequest http = (HttpRequest)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_REQUEST);
        Map params = (Map)ctx.getObject(IBusPGGatelineContextKeys.REQUEST_PARAMETERS.name());
        StringBuilder sb = new StringBuilder("/").append(operation).append(";");
        if (params != null) {
            int i = 0;
            TreeSet<Map.Entry<String, String>> sortedSet = new TreeSet<Map.Entry<String, String>>(new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            sortedSet.addAll(params.entrySet());
            for (Map.Entry entry : sortedSet) {
                if (i > 0) {
                    sb.append(";");
                }
                sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
                ++i;
            }
        }
        PGParameters pgParams = (PGParameters)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.SALES_POINT_PG_PARAMETERS);
        http.getRequestProperties().put((Object)"X-Authorization", (Object)String.format("%s %s", pgParams.getPgAccount().split(";")[0], this.hmacSha1(sb.toString(), pgParams.getPgPassword().split(";")[0])));
        http.setCustomSsocketFactory((Object)this.getSSLFactory(pgParams));
    }

    private String hmacSha1(String value, String key) {
        try {
            byte[] keyBytes = key.getBytes();
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(value.getBytes());
            byte[] hexBytes = new Hex().encode(rawHmac);
            return new String(hexBytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory getSSLFactory(PGParameters pgParams) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        if (!pgParams.getPgAccount().contains(";") || !pgParams.getPgPassword().contains(";")) {
            return null;
        }
        String certFileName = pgParams.getPgAccount().split(";")[1];
        String certPassword = pgParams.getPgPassword().split(";")[1];
        KeyStore clientStore = KeyStore.getInstance("PKCS12");
        String path = "pg/GATELINE/" + certFileName;
        File result = new File(Environment.getConfigurationFolder(), path);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(result);
            clientStore.load(new FileInputStream(result), certPassword.toCharArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fis);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(clientStore, certPassword.toCharArray());
        KeyManager[] kms = kmf.getKeyManagers();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(clientStore);
        SSLContext sslContext = null;
        sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kms, new TrustManager[]{trustManager}, new SecureRandom());
        return sslContext.getSocketFactory();
    }
}

