/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.gateline.initiate;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.pg.gateline.GatelinePgSettings;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.gateline.GatelinePgHelper;
import com.gridnine.xtrip.server.pg.gateline.IBusPGGatelineContextKeys;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import com.gridnine.xtrip.server.pg.split.SplitPaymentHelper;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class InitiateRequestBuilder
extends BaseProcessor {
    private static final String OPERATION = "checkout/pay";

    public void process(MessageContext ctx) throws Exception {
        GatelinePgSettings result = (GatelinePgSettings)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_SETTINGS);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUseTrustfulHostnameVerifier(true);
        httpRequest.setUseTrustfulManager(false);
        httpRequest.setRequestMethod(RequestMethod.POST);
        httpRequest.setUrl(result.getServiceUrl() + OPERATION);
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
        ctx.putObject((Enum)IBusPGGatelineContextKeys.OPERATION, (Object)OPERATION);
        this.fillParams(ctx, httpRequest);
    }

    private void fillParams(MessageContext ctx, HttpRequest httpRequest) throws PGException, UnsupportedEncodingException {
        PaymentInitiationParameters params = (PaymentInitiationParameters)ctx.getMandatoryObject((Enum)IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        payment.setPaymentId(((BookingFile)bookingFile.getEntity()).getNumber());
        requestParams.put("merchant_order_id", payment.getPaymentId());
        GatelinePgSettings settings = (GatelinePgSettings)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_SETTINGS);
        Collection reservations = PaymentHelper.getReservations((EntityContainer)bookingFile, (Collection)payment.getReservations());
        BigDecimal totalPrice = GatelinePgHelper.getTotalPrice(params.getPayment(), settings, ContractType.CLIENT, (EntityContainer<BookingFile>)bookingFile, reservations);
        requestParams.put("amount", GatelinePgHelper.getDecimalFormat().format(totalPrice));
        if (reservations != null) {
            requestParams.put("description", "\u041e\u043f\u043b\u0430\u0442\u0430 " + (reservations.size() == 1 ? "\u0437\u0430\u043a\u0430\u0437\u0430 " : "\u0437\u0430\u043a\u0430\u0437\u043e\u0432 ") + reservations.stream().map(CommonReservationGdsNameInfoHelper::getDisplayedRecordLocator).collect(Collectors.joining(", ")));
        } else {
            Reservation baseProductReservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)bookingFile.getEntity()));
            requestParams.put("description", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0437\u0430\u043a\u0430\u0437\u0430 " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)baseProductReservation));
        }
        requestParams.put("mobile", "no");
        requestParams.put("return_success_url", params.getReturnUrl() + "&status=1");
        requestParams.put("return_failure_url", params.getReturnUrl() + "&status=1");
        if (params.getPayment().getPaymentType() == PaymentType.GATELINE_CREDIT_CARD_SPLIT) {
            this.fillGdsField((BookingFile)bookingFile.getEntity(), reservations, requestParams, totalPrice);
        }
        httpRequest.setBody(GatelinePgHelper.createParamsString(requestParams).toString().getBytes());
        ctx.putObject((Enum)IBusPGGatelineContextKeys.REQUEST_PARAMETERS, requestParams);
    }

    private void fillGdsField(BookingFile bookingFile, Collection<Reservation> reservations, Map<String, String> requestParams, BigDecimal totalPrice) throws PGException {
        Traveller mainTraveller;
        Reservation baseProductReservation;
        if (reservations != null) {
            baseProductReservation = reservations.iterator().next();
            Product product = PaymentHelper.getSplitProduct((Reservation)baseProductReservation);
            Collection travellers = GeneralProductHelper.getHandler((BaseProduct)product).getTravellers((BaseProduct)product);
            mainTraveller = (Traveller)travellers.iterator().next();
        } else {
            baseProductReservation = BookingHelper.getBaseProductReservation((BookingFile)bookingFile);
            mainTraveller = (Traveller)bookingFile.getTravellers().get(0);
        }
        JSONObject extendedParams = new JSONObject();
        JSONObject gdsParams = new JSONObject();
        extendedParams.put("gds", (Object)gdsParams);
        BigDecimal splitPaymentCommisionPartAmount = SplitPaymentHelper.getSplitPaymentCommisionPartAmount((Collection)MidofficeHelper.getReservations((BookingFile)bookingFile, reservations), (BigDecimal)totalPrice);
        BigDecimal ticketsPrice = totalPrice.subtract(splitPaymentCommisionPartAmount);
        GdsName gdsName = CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)baseProductReservation);
        gdsParams.put("amount", (Object)GatelinePgHelper.getDecimalFormat().format(ticketsPrice));
        gdsParams.put("provider", gdsName != null ? gdsName.toString().toUpperCase() : null);
        gdsParams.put("name", (Object)mainTraveller.getPassport().getLastName());
        gdsParams.put("pnr", (Object)CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)baseProductReservation));
        Collection acceptableCards = reservations != null ? PaymentHelper.getAcceptedCards(reservations) : PaymentHelper.getAcceptedCards((BookingFile)bookingFile);
        HashMap<String, String> map = new HashMap<String, String>();
        for (AirlineCard airlineCard : acceptableCards) {
            String code = airlineCard.getCode();
            CardVendor vendor = airlineCard.getVendor();
            if (vendor == null || TextUtil.isBlank((String)code)) continue;
            if (vendor == CardVendor.VISA) {
                map.put("visa", code);
            }
            if (vendor == CardVendor.MASTERCARD) {
                map.put("mastercard", code);
            }
            if (vendor == CardVendor.AMEX) {
                map.put("amex", code);
            }
            if (vendor != CardVendor.JCB) continue;
            map.put("jcb", code);
        }
        if (map.size() == 0) {
            throw new PGException("acceptable_cards empty");
        }
        JSONObject acceptable_cards = new JSONObject();
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            acceptable_cards.put((String)entry.getKey(), entry.getValue());
        }
        gdsParams.put("acceptable_cards", (Object)acceptable_cards);
        requestParams.put("extended", extendedParams.toString());
    }
}

