/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.millikart;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGHelper;
import java.util.HashMap;

public class MilliKartPGConnector
extends PGConnector {
    private Tracer tracer;
    private boolean disposed;

    public PgName getId() {
        return PgName.MILLIKART;
    }

    protected void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.tracer = PGHelper.createTracer((PgName)this.getId());
        this.log.debug("configured");
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_MILLIKART);
        return result;
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        if (this.disposed) {
            throw new IllegalStateException("dispose");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS.name(), parameters);
        data.put(IBusPgContextKeys.PG_CONNECTOR.name(), (Object)this);
        parameters.setDontDoReprice(true);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("pg-connector:initiate-payment-route", data);
        PaymentInitiationResult response = (PaymentInitiationResult)data.get(IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS.name());
        return response;
    }

    protected Long getQueuePeriod() {
        return null;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS.name(), parameters);
        data.put(IBusPgContextKeys.PG_CONNECTOR.name(), (Object)this);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("pg-connector:check-payment-route", data);
        PaymentCheckResult response = (PaymentCheckResult)data.get(IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS.name());
        return response;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }
}

