/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.millikart;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.pg.millikart.MillikartConfiguration;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class MillikartHelper {
    public static final String BACK_URL_KEY = MillikartHelper.class.getName() + ".BACK_URL";
    private static final Logger log = Logger.getLogger(MillikartHelper.class);

    public static BigDecimal getTotalPrice(Payment payment, MillikartConfiguration configuration, ContractType contractType) throws PGException {
        try {
            BigDecimal totalPrice = configuration.isTestingMode() ? BigDecimal.valueOf(configuration.getTestAmount().intValue()) : (BigDecimal)PaymentHelper.getTotalPrices((EntityReference)payment.getEntity(), (ContractType)contractType).get(payment.getPaymentType());
            return totalPrice;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw new PGException("Cannot get total price");
        }
    }

    public static String amountToMillaAmount(BigDecimal value) {
        String amount = String.valueOf(value.intValue() * 100);
        return amount;
    }
}

