/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.millikart;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ProtocolOverridingSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory underlyingSSLSocketFactory;
    private final String[] enabledProtocols;

    public ProtocolOverridingSSLSocketFactory(SSLSocketFactory delegate, String[] enabledProtocols) {
        this.underlyingSSLSocketFactory = delegate;
        this.enabledProtocols = enabledProtocols;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.underlyingSSLSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.underlyingSSLSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(socket, host, port, autoClose);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port, localAddress, localPort);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket underlyingSocket = this.underlyingSSLSocketFactory.createSocket(host, port, localAddress, localPort);
        return this.overrideProtocol(underlyingSocket);
    }

    private Socket overrideProtocol(Socket socket) {
        if (socket instanceof SSLSocket && this.enabledProtocols != null && this.enabledProtocols.length > 0) {
            ((SSLSocket)socket).setEnabledProtocols(this.enabledProtocols);
        }
        return socket;
    }
}

