/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.millikart.check;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.pg.millikart.MillikartConfiguration;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;

public class CheckRequestBuilder
extends BaseProcessor {
    private static final String URL_CONTEXT = "/exec";

    public void process(MessageContext ctx) throws Exception {
        MillikartConfiguration config = (MillikartConfiguration)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_SETTINGS);
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        String url = config.getServiceUrl() + URL_CONTEXT;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.tag.name(), (Object)"MillikartOrderIdAndSessionId"));
        TemporalObject requestObject = null;
        for (TemporalObject obj : LogicalStorage.get().getAssetStorage().search(TemporalObject.class, query).getData()) {
            if (!obj.getUid().equals("payment " + payment.getPaymentId())) continue;
            requestObject = obj;
            break;
        }
        if (requestObject == null) {
            throw Xeption.forDeveloper((String)"\u041d\u0435 \u043d\u0430\u0448\u0451\u043b\u0441\u044f \u043e\u0431\u044a\u0435\u043a\u0442 \u0441\u0432\u044f\u0437\u043a\u0438 Payment uid - OrderID;SessionID", (Object[])new Object[0]);
        }
        String[] orderAndSessionIDs = new String(requestObject.getData()).split(";");
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUseTrustfulHostnameVerifier(true);
        httpRequest.setUseTrustfulManager(true);
        httpRequest.setRequestMethod(RequestMethod.POST);
        httpRequest.setBody(this.createRequestBody(orderAndSessionIDs[0], orderAndSessionIDs[1]));
        httpRequest.setUrl(url);
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
    }

    private byte[] createRequestBody(String orderId, String sessionId) {
        return ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<TKKPG>\n <Request>\n  <Operation>GetOrderStatus</Operation>\n  <Language>EN</Language>\n  <Order>\n   <Merchant>biletbank</Merchant>\n   <OrderID>" + orderId + "</OrderID>\n  </Order>\n  <SessionID>" + sessionId + "</SessionID>\n </Request></TKKPG>").getBytes();
    }
}

