/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.millikart.initiate;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.pg.millikart.MillikartConfiguration;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import com.gridnine.xtrip.server.pg.millikart.MillikartHelper;
import java.math.BigDecimal;

public class InitiateRequestBuilder
extends BaseProcessor {
    private static final String URL_CONTEXT = "/exec";

    public void process(MessageContext ctx) throws Exception {
        MillikartConfiguration config = (MillikartConfiguration)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_SETTINGS);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        PGParameters pgParams = (PGParameters)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.SALES_POINT_PG_PARAMETERS);
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        PGConnector connector = (PGConnector)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PG_CONNECTOR);
        Reservation baseProductReservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)bookingFile.getEntity()));
        String pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)baseProductReservation);
        String mid = pgParams.getPgAccount();
        BigDecimal totalPrice = MillikartHelper.getTotalPrice(payment, config, connector.getContractType());
        String amount = MillikartHelper.amountToMillaAmount(totalPrice);
        String description = "Payment order " + TextUtil.translit((String)pnr, (boolean)true);
        String url = config.getServiceUrl() + URL_CONTEXT;
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUseTrustfulHostnameVerifier(true);
        httpRequest.setUseTrustfulManager(true);
        httpRequest.setRequestMethod(RequestMethod.POST);
        httpRequest.setBody(this.createRequestBody(mid, amount, description));
        httpRequest.setUrl(url);
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
    }

    private byte[] createRequestBody(String mid, String amount, String description) {
        return ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<TKKPG>\n <Request>\n  <Operation>CreateOrder</Operation>\n  <Language>EN</Language>\n  <Order>\n   <OrderType>Purchase</OrderType>\n   <Merchant>" + mid + "</Merchant>\n   <Amount>" + amount + "</Amount>\n   <Currency>944</Currency>\n   <Description>" + description + "</Description>\n   <ApproveURL>http://b2c.az.sc.gridnine.com/millikart/register/payment</ApproveURL>\n   <CancelURL>http://b2c.az.sc.gridnine.com/millikart/register/payment</CancelURL>\n   <DeclineURL>http://b2c.az.sc.gridnine.com/millikart/register/payment</DeclineURL>\n  </Order>\n </Request></TKKPG>").getBytes();
    }
}

