/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.millikart.initiate;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.Date;
import org.w3c.dom.Element;

public class InitiateResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        HttpResponse response = (HttpResponse)ctx.getMandatoryObject(IBusHttpContextKeys.HTTP_RESPONSE.name());
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        Element element = XUtil.fromBytes((byte[])response.getBody());
        String responseCode = XmlUtil.getValue((Element)XmlUtil.getElement((Element)element, (String)"/TKKPG/Response/Status"));
        if (!"00".equals(responseCode)) {
            throw Xeption.forAdmin((String)"Invalid response", (Object[])new Object[0]);
        }
        String responseRedirectUrl = XmlUtil.getValue((Element)XmlUtil.getElement((Element)element, (String)"/TKKPG/Response/Order/URL"));
        PaymentInitiationResult resultParams = (PaymentInitiationResult)ctx.getMandatoryObject((Enum)IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS);
        resultParams.getRedirectForm().setUrl(responseRedirectUrl);
        NamedValue sessionId = new NamedValue();
        sessionId.setName("SessionID");
        sessionId.setValue(XmlUtil.getValue((Element)XmlUtil.getElement((Element)element, (String)"/TKKPG/Response/Order/SessionID")));
        NamedValue orderId = new NamedValue();
        orderId.setName("OrderID");
        orderId.setValue(XmlUtil.getValue((Element)XmlUtil.getElement((Element)element, (String)"/TKKPG/Response/Order/OrderID")));
        resultParams.getRedirectForm().getParameters().add(sessionId);
        resultParams.getRedirectForm().getParameters().add(orderId);
        this.saveTemporalObjects(orderId, sessionId, payment.getPaymentId());
    }

    private void saveTemporalObjects(NamedValue orderId, NamedValue sessionId, String paymentId) {
        TemporalObject orderToPayment = new TemporalObject(orderId.getValue());
        orderToPayment.setExpired(new Date(System.currentTimeMillis() + 900000L));
        orderToPayment.setTag("MillikartOrderIdToPaymentId");
        orderToPayment.setData(paymentId.getBytes());
        LogicalStorage.get().getAssetStorage().save((BaseAsset)orderToPayment);
        TemporalObject paymentToOrderAndSession = new TemporalObject("payment " + paymentId);
        paymentToOrderAndSession.setExpired(new Date(System.currentTimeMillis() + 900000L));
        paymentToOrderAndSession.setTag("MillikartOrderIdAndSessionId");
        paymentToOrderAndSession.setData((orderId.getValue() + ";" + sessionId.getValue()).getBytes());
        LogicalStorage.get().getAssetStorage().save((BaseAsset)paymentToOrderAndSession);
    }
}

