/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.millikart.servlet;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import com.gridnine.xtrip.server.pg.millikart.MillikartHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MillikartRegisterPaymentServlet
extends PGServlet {
    private static final long serialVersionUID = 7895298286426765087L;
    private static final Logger log = LoggerFactory.getLogger(MillikartRegisterPaymentServlet.class);

    protected PgName getId() {
        return PgName.MILLIKART;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("MillikartRegisterPaymentServlet service() BEGIN");
        PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
        Date startServiceDate = new Date();
        PGServletResponse pgServletResponse = new PGServletResponse(response);
        Map requestParameters = request.getParameterMap();
        Map logParameters = PGHelper.toLogParameters((Map)requestParameters);
        ArrayList pgLog = new ArrayList();
        try {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.tag.name(), (Object)"MillikartOrderIdToPaymentId"));
            TemporalObject paymentIdObject = null;
            String xml = ((String[])requestParameters.values().iterator().next())[0];
            String orderId = xml.substring(xml.indexOf("<OrderID>") + 9, xml.indexOf("</OrderID>"));
            for (TemporalObject obj : LogicalStorage.get().getAssetStorage().search(TemporalObject.class, query).getData()) {
                if (!obj.getUid().equals(orderId)) continue;
                paymentIdObject = obj;
                break;
            }
            if (paymentIdObject == null) {
                throw Xeption.forDeveloper((String)"\u041d\u0435 \u043d\u0430\u0448\u0451\u043b\u0441\u044f \u043e\u0431\u044a\u0435\u043a\u0442 \u0441\u0432\u044f\u0437\u043a\u0438 OrderID - Payment uid", (Object[])new Object[0]);
            }
            Payment payment = this.getFromQueue(new String(paymentIdObject.getData()));
            Objects.requireNonNull(payment, "null Payment");
            String redirectUrl = NamedValueHelper.getValueForName((String)MillikartHelper.BACK_URL_KEY, (Collection)payment.getCustomParameters());
            Objects.requireNonNull(redirectUrl, "null redirectUrl");
            PGHelper.redirect((PGServletResponse)pgServletResponse, (String)redirectUrl);
        }
        catch (Throwable t) {
            log.error("MillikartRegisterPaymentServlet service() FAILED", t);
            PGInvocationContext.get().addTraceData(0, startServiceDate, InvocationName.SERVLET_SERVICE.toString(), (Object)logParameters, (Object)pgServletResponse, t);
            pgServletResponse.setResponseCode(500);
            pgServletResponse.setResponseText(t.getMessage());
        }
        finally {
            log.debug("MillikartRegisterPaymentServlet service() END");
            PGInvocationContext.get().addTraceData(0, startServiceDate, InvocationName.SERVLET_SERVICE.toString(), (Object)logParameters, (Object)pgServletResponse, null);
            PGInvocationContext.get().end(this.getConnector(), pgLog);
            pgServletResponse.send();
        }
    }
}

