/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.paybox;

import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.pg.paybox.HandlerSecurity;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HandlerSecurityTest
extends TestBase {
    @Test
    public void testInjectSecurity() {
        Document doc = DocumentBuilderHelper.newDocument();
        Element request = doc.createElement("request");
        doc.appendChild(request);
        XHelper.writeString((Element)request, (String)"pg_t_param", (String)"value3");
        XHelper.writeString((Element)request, (String)"pg_a_param", (String)"value1");
        Element zParam = XmlUtil.addElement((Element)request, (String)"pg_z_param");
        XHelper.writeString((Element)zParam, (String)"pg_q_subparam", (String)"subvalue2");
        XHelper.writeString((Element)zParam, (String)"pg_m_subparam", (String)"subvalue1");
        XHelper.writeString((Element)request, (String)"pg_b_param", (String)"value2");
        HandlerSecurity.injectSecurity(request, "http://domain.com/path/to/script.php", "mypasskey");
        String pgSalt = XHelper.readString((Element)request, (String)"pg_salt");
        Assert.assertFalse((boolean)TextUtil.isBlank((String)pgSalt));
        Assert.assertTrue((boolean)Pattern.compile("[A-Za-z0-9]*").matcher(pgSalt).matches());
        String pgSig = XHelper.readString((Element)request, (String)"pg_sig");
        Assert.assertFalse((boolean)TextUtil.isBlank((String)pgSig));
        String expectedSig = MiscUtil.md5((String)("script.php;value1;value2;" + pgSalt + ";value3;subvalue1;subvalue2;mypasskey"));
        Assert.assertEquals((Object)expectedSig, (Object)pgSig);
    }

    @Test
    public void testCheckSecurity() {
        Document doc = DocumentBuilderHelper.newDocument();
        Element request = doc.createElement("request");
        doc.appendChild(request);
        XHelper.writeString((Element)request, (String)"pg_t_param", (String)"value3");
        XHelper.writeString((Element)request, (String)"pg_a_param", (String)"value1");
        Element zParam = XmlUtil.addElement((Element)request, (String)"pg_z_param");
        XHelper.writeString((Element)zParam, (String)"pg_q_subparam", (String)"subvalue2");
        XHelper.writeString((Element)zParam, (String)"pg_m_subparam", (String)"subvalue1");
        XHelper.writeString((Element)request, (String)"pg_b_param", (String)"value2");
        String url = "http://domain.com/path/to/script.php";
        String secretKey = "mypasskey";
        HandlerSecurity.injectSecurity(request, url, secretKey);
        try {
            HandlerSecurity.checkSecurity(request, url, secretKey);
        }
        catch (SecurityException ex) {
            Assert.fail((String)"security check failed for valid pg_sig");
        }
        XmlUtil.setValue((Element)XmlUtil.getElement((Element)request, (String)"pg_sig"), (String)(XHelper.readString((Element)request, (String)"pg_sig") + "1"));
        try {
            HandlerSecurity.checkSecurity(request, url, secretKey);
            Assert.fail((String)"security check succeeded for invalid pg_sig");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckSecurity2() {
        Document doc = DocumentBuilderHelper.newDocument();
        Element request = doc.createElement("request");
        doc.appendChild(request);
        XHelper.writeString((Element)request, (String)"pg_t_param", (String)"value3");
        XHelper.writeString((Element)request, (String)"pg_a_param", (String)"value1");
        Element zParam = XmlUtil.addElement((Element)request, (String)"pg_z_param");
        XHelper.writeString((Element)zParam, (String)"pg_q_subparam", (String)"subvalue2");
        XHelper.writeString((Element)zParam, (String)"pg_m_subparam", (String)"subvalue1");
        XHelper.writeString((Element)zParam, (String)"pg_card_brand", (String)"TP");
        XHelper.writeString((Element)zParam, (String)"pg_card_brand", (String)"JB");
        XHelper.writeString((Element)zParam, (String)"pg_card_brand", (String)"AX");
        XHelper.writeString((Element)zParam, (String)"pg_card_brand", (String)"DC");
        XHelper.writeString((Element)request, (String)"pg_b_param", (String)"value2");
        String url = "http://domain.com/path/to/script.php";
        String secretKey = "mypasskey";
        String buildSecurityLine = HandlerSecurity.buildSecurityLine(request, url, secretKey);
        Assert.assertEquals((Object)"script.php;value1;value2;value3;TP;JB;AX;DC;subvalue1;subvalue2;mypasskey", (Object)buildSecurityLine);
    }
}

