/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.paybox;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.paybox.PayboxSettings;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import com.gridnine.xtrip.server.pg.paybox.PayboxSettingsProvider;
import java.util.HashMap;
import java.util.Map;

public class PayboxPGConnector
extends PGConnector {
    static final String AUDIT_TAG_PREFIX = "paybox-pgconnector";
    public static final String BUS_CONTEXT_KEYS_REQUEST_ELEMENT = "BUS_CONTEXT_KEYS_REQUEST_ELEMENT";
    private boolean disposed;
    private boolean enabled;
    private PayboxSettings settings;
    private Tracer tracer;

    public PgName getId() {
        return PgName.PAYBOX;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.enabled;
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        for (PaymentType type : PaymentType.values()) {
            if (!type.name().endsWith("_PAYBOX")) continue;
            result.getSupportedPaymentTypes().add(type);
        }
        return result;
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS.name(), parameters);
        data.put(IBusPgContextKeys.PG_CONNECTOR.name(), (Object)this);
        data.put(IBusPgConnectorContextKeys.PG_SETTINGS.name(), this.settings);
        parameters.setDontDoReprice(true);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("pg-connector:initiate-payment-route", data);
        PaymentInitiationResult response = (PaymentInitiationResult)data.get(IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS.name());
        return response;
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS.name(), parameters);
        data.put(IBusPgContextKeys.PG_CONNECTOR.name(), (Object)this);
        data.put(IBusPgConnectorContextKeys.PG_SETTINGS.name(), this.settings);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("pg-connector:check-payment-route", data);
        PaymentCheckResult response = (PaymentCheckResult)data.get(IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS.name());
        return response;
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters, Map<String, Object> ctx) {
        ctx.put(IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS.name(), parameters);
        ctx.put(IBusPgContextKeys.PG_CONNECTOR.name(), (Object)this);
        ctx.put(IBusPgConnectorContextKeys.PG_SETTINGS.name(), this.settings);
        ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).processRouteSync("pg-connector:check-payment-route", ctx);
        PaymentCheckResult response = (PaymentCheckResult)ctx.get(IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS.name());
        return response;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    public void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.enabled = true;
        this.settings = (PayboxSettings)new PayboxSettingsProvider().get();
        if (this.settings.isTestingMode()) {
            this.tracer = PGHelper.createTracer((PgName)this.getId());
        }
    }

    public PayboxSettings getSettings() {
        return this.settings;
    }
}

