/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.paybox;

import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.paybox.HandlerSecurity;
import com.gridnine.xtrip.server.pg.paybox.PayboxPGConnector;
import com.gridnine.xtrip.server.pg.paybox.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class PayboxPGServlet
extends PGServlet {
    private static final long serialVersionUID = -3694655557374307984L;
    private static final Logger log = LoggerFactory.getLogger(PayboxPGServlet.class);

    protected PgName getId() {
        return PgName.PAYBOX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        block22: {
            Payment payment;
            String secretKey;
            Element response;
            Element request;
            Date startDate;
            block21: {
                block20: {
                    log.debug("service() BEGIN");
                    PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
                    startDate = new Date();
                    String strRequest = IOUtils.toString((InputStream)req.getInputStream(), (String)"UTF-8");
                    if (!strRequest.startsWith("pg_xml=")) {
                        res.getOutputStream().print("<html><body><p>All works correctly. Expected parameter pg_xml</p></body></html>");
                        return;
                    }
                    if (strRequest.startsWith("pg_xml=")) {
                        strRequest = strRequest.replace("pg_xml=", "");
                    }
                    String xmlString = URLDecoder.decode(strRequest, "UTF-8");
                    request = null;
                    String paymentId = null;
                    Document doc = DocumentBuilderHelper.newDocument();
                    response = doc.createElement("response");
                    doc.appendChild(response);
                    secretKey = null;
                    payment = null;
                    this.authorizeLogicalStorage();
                    request = DocumentBuilderHelper.parse((InputSource)new InputSource(new StringReader(xmlString))).getDocumentElement();
                    paymentId = XHelper.readString((Element)request, (String)"pg_order_id");
                    PGInvocationContext.get().setPaymentId(paymentId);
                    payment = this.getFromQueue(paymentId);
                    if (payment != null) break block20;
                    XHelper.writeString((Element)response, (String)"pg_status", (String)"error");
                    XHelper.writeString((Element)response, (String)"pg_error_description", (String)"payment already processed or not found");
                    PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                    try {
                        XUtil.newTransformer().transform(new DOMSource(response), new StreamResult((OutputStream)res.getOutputStream()));
                    }
                    catch (Throwable t) {
                        res.sendError(500, t.getMessage());
                        log.error("response sending failed", t);
                    }
                    PGInvocationContext.get().end(this.getConnector(), null);
                    LogicalStorage.reset();
                    return;
                }
                secretKey = PGRulesHelper.getPGParameters((SalesContext)PaymentHelper.restoreSalesContext((Payment)payment), (PgName)this.getId(), (Payment)payment).getPgPassword();
                if (secretKey != null) break block21;
                XHelper.writeString((Element)response, (String)"pg_status", (String)"error");
                XHelper.writeString((Element)response, (String)"pg_error_description", (String)"secret key not found. check paybox configuration");
                PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                try {
                    XUtil.newTransformer().transform(new DOMSource(response), new StreamResult((OutputStream)res.getOutputStream()));
                }
                catch (Throwable t) {
                    res.sendError(500, t.getMessage());
                    log.error("response sending failed", t);
                }
                PGInvocationContext.get().end(this.getConnector(), null);
                LogicalStorage.reset();
                return;
            }
            HandlerSecurity.checkSecurity(request, ((PayboxPGConnector)this.getConnector()).getSettings().getResultUrl(), secretKey);
            PaymentType paymentTypeFromString = Util.paymentTypeFromString(XHelper.readString((Element)request, (String)"pg_payment_system"));
            payment.setPaymentType(paymentTypeFromString);
            PaymentCheckParameters checkParams = new PaymentCheckParameters();
            checkParams.setPayment(payment);
            PaymentCheckResult checkResult = this.getConnector().checkPayment(checkParams);
            if (checkResult.isSuccess()) {
                XHelper.writeString((Element)response, (String)"pg_status", (String)"ok");
            } else {
                XHelper.writeString((Element)response, (String)"pg_status", (String)"error");
            }
            HandlerSecurity.injectSecurity(response, ((PayboxPGConnector)this.getConnector()).getSettings().getResultUrl(), secretKey);
            PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
            try {
                XUtil.newTransformer().transform(new DOMSource(response), new StreamResult((OutputStream)res.getOutputStream()));
            }
            catch (Throwable t) {
                res.sendError(500, t.getMessage());
                log.error("response sending failed", t);
            }
            PGInvocationContext.get().end(this.getConnector(), null);
            LogicalStorage.reset();
            break block22;
            catch (Throwable t) {
                try {
                    log.error("service failed", t);
                    XHelper.writeString((Element)response, (String)"pg_status", (String)"error");
                    XHelper.writeString((Element)response, (String)"pg_error_description", (String)t.getMessage());
                    PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, t);
                }
                catch (Throwable throwable) {
                    PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), request, (Object)response, null);
                    try {
                        XUtil.newTransformer().transform(new DOMSource(response), new StreamResult((OutputStream)res.getOutputStream()));
                    }
                    catch (Throwable t2) {
                        res.sendError(500, t2.getMessage());
                        log.error("response sending failed", t2);
                    }
                    PGInvocationContext.get().end(this.getConnector(), null);
                    LogicalStorage.reset();
                    throw throwable;
                }
                PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                try {
                    XUtil.newTransformer().transform(new DOMSource(response), new StreamResult((OutputStream)res.getOutputStream()));
                }
                catch (Throwable t3) {
                    res.sendError(500, t3.getMessage());
                    log.error("response sending failed", t3);
                }
                PGInvocationContext.get().end(this.getConnector(), null);
                LogicalStorage.reset();
            }
        }
    }
}

