/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.paybox.check;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.helpers.util.CardVendorUtils;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.paybox.IBusPayboxPgContextKeys;
import com.gridnine.xtrip.common.pg.paybox.PAYBOX_PAYMENT_STATUS;
import com.gridnine.xtrip.common.pg.paybox.PayboxCheckPaymentResponse;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import com.gridnine.xtrip.server.pg.paybox.Util;
import org.w3c.dom.Element;

public class CheckResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        HttpResponse response = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        if (response.getResponseCode() != 200) {
            throw Xeption.forAdmin((String)("Invalid response code " + response.getResponseCode()), (Object[])new Object[0]);
        }
        PayboxCheckPaymentResponse checkResponse = new PayboxCheckPaymentResponse();
        Element element = XUtil.fromBytes((byte[])response.getBody());
        checkResponse.fromXML(element);
        if (checkResponse == null) {
            throw new PGException("CheckPaymentResponse is null");
        }
        ctx.putObject((Enum)IBusPayboxPgContextKeys.CHECK_PAYMENT_RESPONSE, (Object)checkResponse);
        CheckResponseParser.processResponse(checkResponse, payment);
    }

    public static void processResponse(PayboxCheckPaymentResponse response, Payment payment) throws PGException {
        if (!"ok".equals(response.getPg_status())) {
            String errorCode = response.getPg_failure_code();
            String errorDescription = response.getPg_failure_description();
            throw new PGException("\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: " + errorCode + " (" + Util.getErrorText(Integer.parseInt(errorCode)) + ") " + errorDescription);
        }
        if (response.getPg_transaction_status() != PAYBOX_PAYMENT_STATUS.ok) {
            throw new PGException("\u041f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d");
        }
        CardTransactionDetails cardTransactionDetails = new CardTransactionDetails();
        if (response.getPg_card_pan() != null) {
            cardTransactionDetails.setNumber(response.getPg_card_pan().replace("-", ""));
        }
        if (TextUtil.nonBlank((String)response.getPg_card_brand())) {
            cardTransactionDetails.setVendor(CheckResponseParser.getVendor(response.getPg_card_brand()));
        } else if (TextUtil.nonBlank((String)cardTransactionDetails.getNumber())) {
            cardTransactionDetails.setVendor(CardVendorUtils.determineCardIssuer((String)cardTransactionDetails.getNumber()));
        }
        cardTransactionDetails.setSecurityCode(response.getPg_auth_code());
        payment.setDetails(cardTransactionDetails);
    }

    private static CardVendor getVendor(String vendorCode) {
        if (TextUtil.isBlank((String)vendorCode)) {
            return null;
        }
        switch (vendorCode) {
            case "CA": {
                return CardVendor.MASTERCARD;
            }
            case "VI": {
                return CardVendor.VISA;
            }
            case "AX": {
                return CardVendor.AMEX;
            }
        }
        return null;
    }
}

