/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.paybox.initiate;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.paybox.IBusPayboxPgContextKeys;
import com.gridnine.xtrip.common.pg.paybox.PayboxSettings;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import com.gridnine.xtrip.server.pg.paybox.Util;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InitiateRequestBuilder
extends BaseProcessor {
    private static final ThreadLocal<NumberFormat> NUMBER_FORMAT = ThreadLocal.withInitial(() -> {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        return new DecimalFormat("0.00", decimalFormatSymbols);
    });

    public void process(MessageContext ctx) throws Exception {
        PayboxSettings settings = (PayboxSettings)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_SETTINGS);
        PaymentInitiationParameters params = (PaymentInitiationParameters)ctx.getMandatoryObject((Enum)IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        PGParameters pgParams = (PGParameters)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.SALES_POINT_PG_PARAMETERS);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUseTrustfulHostnameVerifier(true);
        httpRequest.setUseTrustfulManager(true);
        httpRequest.setRequestMethod(RequestMethod.POST);
        httpRequest.setUrl(settings.getInitPaymentUrl());
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
        Element el = InitiateRequestBuilder.prepareRequest(pgParams, params, settings, (EntityContainer<BookingFile>)bookingFile);
        ctx.putObject((Enum)IBusPayboxPgContextKeys.PG_XML, (Object)el);
    }

    public static Element prepareRequest(PGParameters pgParameters, PaymentInitiationParameters parameters, PayboxSettings configuration, EntityContainer<BookingFile> bookingFile) throws Exception {
        Collection phoneCommunications;
        Document doc = DocumentBuilderHelper.newDocument();
        Element request = doc.createElement("request");
        doc.appendChild(request);
        XHelper.writeString((Element)request, (String)"pg_merchant_id", (String)pgParameters.getPgAccount());
        Payment payment = parameters.getPayment();
        XHelper.writeString((Element)request, (String)"pg_order_id", (String)payment.getPaymentId());
        BigDecimal totalAmount = payment.getAmount();
        XHelper.writeString((Element)request, (String)"pg_amount", (String)NUMBER_FORMAT.get().format(totalAmount.doubleValue()));
        BaseProduct product = (BaseProduct)((Reservation)((BookingFile)bookingFile.getEntity()).getReservations().get(0)).getProducts().get(0);
        XHelper.writeString((Element)request, (String)"pg_currency", (String)GeneralProductHelper.getHandler((BaseProduct)product).getGdsCurrency(product));
        XHelper.writeString((Element)request, (String)"pg_result_url", (String)configuration.getResultUrl());
        XHelper.writeString((Element)request, (String)"pg_request_method", (String)"XML");
        XHelper.writeString((Element)request, (String)"pg_success_url", (String)(parameters.getReturnUrl() + "&status=1"));
        XHelper.writeString((Element)request, (String)"pg_failure_url", (String)(parameters.getReturnUrl() + "&status=0"));
        XHelper.writeString((Element)request, (String)"pg_success_url_method", (String)configuration.getReturnUrlMethod());
        XHelper.writeString((Element)request, (String)"pg_failure_url_method", (String)configuration.getReturnUrlMethod());
        XHelper.writeString((Element)request, (String)"pg_payment_system", (String)Util.paymentType2String(payment.getPaymentType()));
        Person customer = null;
        if (parameters.getSalesContext().getCustomer() != null && (customer = (Person)EntityStorage.get().resolve(parameters.getSalesContext().getCustomer()).getEntity()) != null && (phoneCommunications = ProfileHelper.getPhoneCommunications((List)customer.getCommunications())).size() > 0) {
            String phone = ProfileHelper.buildFullPhoneNumber((Communication)((Communication)phoneCommunications.iterator().next())).replace("+", "").replace("(", "").replace(")", "").replace(" ", "");
            XHelper.writeString((Element)request, (String)"pg_user_phone", (String)phone);
        }
        if (customer != null) {
            for (PersonCommunication comm : customer.getCommunications()) {
                if (comm.getType() != CommunicationType.EMAIL) continue;
                XHelper.writeString((Element)request, (String)"pg_user_email", (String)comm.getSense());
                break;
            }
        }
        XHelper.writeString((Element)request, (String)"pg_description", (String)payment.getDescription());
        XHelper.writeString((Element)request, (String)"pg_language", (String)payment.getCustomerInfo().getPreferredLocale().getLanguage());
        if (configuration.isTestingMode()) {
            XHelper.writeString((Element)request, (String)"pg_testing_mode", (String)"1");
        }
        return request;
    }
}

