/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.paybox.initiate;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.RedirectForm;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.paybox.Util;
import org.w3c.dom.Element;

public class InitiateResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        HttpResponse response = (HttpResponse)ctx.getMandatoryObject(IBusHttpContextKeys.HTTP_RESPONSE.name());
        PaymentInitiationResult resultParams = (PaymentInitiationResult)ctx.getMandatoryObject((Enum)IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS);
        if (response.getResponseCode() != 200) {
            throw Xeption.forAdmin((String)("Invalid response code " + response.getResponseCode()), (Object[])new Object[0]);
        }
        Element element = XUtil.fromBytes((byte[])response.getBody());
        InitiateResponseParser.processResponse(resultParams, element);
    }

    public static void processResponse(PaymentInitiationResult result, Element response) throws PGException {
        if (!"ok".equals(XHelper.readString((Element)response, (String)"pg_status"))) {
            int errorCode = XHelper.readInt((Element)response, (String)"pg_error_code", (int)-1);
            String errorDescription = XHelper.readString((Element)response, (String)"pg_error_description");
            throw new PGException("\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: " + errorCode + " (" + Util.getErrorText(errorCode) + ") " + errorDescription);
        }
        result.getPayment().setPgPaymentId(XHelper.readString((Element)response, (String)"pg_payment_id"));
        InitiateResponseParser.buildRedirectForm(XHelper.readString((Element)response, (String)"pg_redirect_url"), result.getRedirectForm());
    }

    public static void buildRedirectForm(String redirectUrl, RedirectForm redirectForm) {
        redirectForm.setUrl(redirectUrl);
        redirectForm.setMethod("GET");
        int indexOf = redirectUrl.indexOf(63);
        if (indexOf == -1) {
            redirectForm.setUrl(redirectUrl);
        } else {
            redirectForm.setUrl(redirectUrl.substring(0, indexOf));
            for (String paramEntry : redirectUrl.substring(indexOf + 1).split("&")) {
                int equalChar = paramEntry.indexOf(61);
                redirectForm.getParameters().add(NamedValueHelper.namedValue((String)paramEntry.substring(0, equalChar), (String)paramEntry.substring(equalChar + 1)));
            }
        }
    }
}

