/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.payonline;

import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.BinHex;
import com.gridnine.xtrip.server.pg.PGException;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class HandlerCheckPayment {
    private static final transient Logger log = LoggerFactory.getLogger(HandlerCheckPayment.class);

    HandlerCheckPayment() {
    }

    static Map<String, String> createRequest(PGParameters params, PaymentCheckParameters pcp) {
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        try {
            request.put("MerchantId", params.getPgAccount());
            request.put("OrderId", pcp.getPayment().getPaymentId());
            request.put("SecurityKey", HandlerCheckPayment.generateSign(params.getPgAccount(), pcp.getPayment().getPaymentId(), params.getPgPassword()));
            request.put("ContentType", "xml");
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
        return request;
    }

    static void processRepsonse(Payment payment, Element response, List<Message> messages) throws Exception {
        Message msg = null;
        Element childEl = null;
        if (response == null) {
            msg = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043f\u043b\u0430\u0442\u0435\u0436 {0} \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {1} \u041d\u0415 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d", (Object[])new Object[]{payment.getPaymentId(), PgName.PAYONLINE});
            messages.add(msg);
            payment.setStatus(PaymentStatus.FAILED);
            return;
        }
        if (!"transaction".equalsIgnoreCase(response.getNodeName())) {
            throw new PGException("invalid xml response : root element must be 'transaction'");
        }
        childEl = (Element)response.getElementsByTagName("status").item(0);
        String status = childEl.getTextContent();
        childEl = (Element)response.getElementsByTagName("id").item(0);
        String transactionId = childEl.getTextContent();
        payment.getCustomParameters().add(NamedValueHelper.namedValue((String)"transaction.status", (String)status));
        payment.getCustomParameters().add(NamedValueHelper.namedValue((String)"transaction.id", (String)transactionId));
        if (!status.equalsIgnoreCase("settled") && !status.equalsIgnoreCase("pending")) {
            throw new Exception("unexpected payment status: " + status);
        }
        msg = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043f\u043b\u0430\u0442\u0435\u0436 {0} \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 {1} \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d", (Object[])new Object[]{payment.getPaymentId(), PgName.PAYONLINE});
        messages.add(msg);
        payment.setStatus(PaymentStatus.SUCCEEDED);
    }

    private static String generateSign(String merchantId, String orderId, String privateSecurityKey) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("MerchantId");
        sb.append("=");
        sb.append(merchantId);
        sb.append("&");
        sb.append("OrderId");
        sb.append("=");
        sb.append(orderId);
        sb.append("&");
        sb.append("PrivateSecurityKey");
        sb.append("=");
        sb.append(privateSecurityKey);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] b = sb.toString().getBytes();
        md5.update(b);
        return BinHex.encode((byte[])md5.digest()).toLowerCase();
    }
}

