/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.payonline;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.pg.SplitPaymentSupport;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.payonline.HandlerInitiatePayment;
import com.gridnine.xtrip.server.pg.payonline.PayonlineConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.w3c.dom.Element;

public class PayonlinePGConnector
extends PGConnector
implements SplitPaymentSupport {
    static final String AUDIT_TAG_PREFIX = "payonline-pgconnector";
    private boolean enabled;
    private boolean disposed;
    private PayonlineConfiguration configuration;
    private Tracer tracer = null;
    static final String TRANSACTION_STATUS = "transaction.status";
    static final String TRANSACTION_ID = "transaction.id";
    static final String SEPARATE_LOG_INVOCATION = "separate.log.invocation";
    static final String CUSTOM_PARAMETER_IS_SPLIT_PAYED = "custom.parameter.is.split.payed";
    static final String CUSTOM_PARAMETER_APPROVAL_CODE = "custom.parameter.approval.code";

    public PgName getId() {
        return PgName.PAYONLINE;
    }

    public PayonlineConfiguration getConnectorConfiguration() {
        return this.configuration;
    }

    protected void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.enabled = true;
        this.configuration = new PayonlineConfiguration(this.getConfiguration());
        if (this.configuration.isTraceEnabled()) {
            this.tracer = PGHelper.createTracer((PgName)this.getId());
        }
        this.enabled = this.configuration.isValid();
        if (this.enabled) {
            this.log.debug("configured");
        } else {
            this.log.warn("invalid configuration, PAYONLINE connector disabled");
        }
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected Long getQueuePeriod() {
        return this.configuration.getQueuePeriod();
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_ONLINE_PAYONLINE);
        result.getSupportedPaymentTypes().add(PaymentType.WEBMONEY_PAYONLINE);
        result.getSupportedPaymentTypes().add(PaymentType.QIWI_PAYONLINE);
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_SUPPLIER_PAYONLINE);
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_AGENCY_PAYONLINE);
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_SPLIT_PAYONLINE);
        return result;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        Payment payment = parameters.getPayment();
        this.doPaymentReprice(payment);
        PGInvocationContext.get().begin(InvocationName.INITIATE_PAYMENT.toString());
        Date startDate = new Date();
        PGInvocationContext.get().setPaymentId(payment.getPaymentId());
        PaymentInitiationResult result = new PaymentInitiationResult();
        result.setPayment(payment);
        try {
            PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)parameters.getSalesContext(), (PgName)parameters.getPg(), (Payment)payment);
            HandlerInitiatePayment.process(result, parameters, pgParameters, this.configuration);
            this.paymentInitiated(result.getPayment(), result.getMessages());
            Message auditMessage = MessageHelper.createMessage((String)("initiate " + parameters.getPayment().getPaymentType()), (Object[])new Object[0]);
            PayonlinePGConnector.auditMessage((EntityReference)parameters.getPayment().getEntity(), (Message)auditMessage, (String)AUDIT_TAG_PREFIX);
            result.setSuccess(true);
            result.getMessages().add(MessageHelper.createMessage((String)"\u041f\u043b\u0430\u0442\u0435\u0436 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d", (String)result.getPayment().getPaymentId(), (Object[])new Object[]{this.getId()}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, null);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (PGException ex) {
            this.log.error("payment initiation failed", (Throwable)ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, (Throwable)ex);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (Throwable t) {
            this.log.error("payment initiation failed", t);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)t));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)"\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", (String)payment.getPaymentId(), (Object[])new Object[]{this.getId()}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, t);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, result.getPgLog());
        }
    }

    /*
     * Exception decompiling
     */
    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Element execute(InvocationName invocationName, Map<String, String> request, String url) throws Exception {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(TextUtil.buildUrl((String)url, request, (String)"Cp1251")).openConnection();
        connection.setRequestMethod("GET");
        connection.setDoInput(true);
        connection.setUseCaches(false);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DataInputStream in = new DataInputStream(connection.getInputStream());){
            IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)256);
        }
        try {
            if (out.size() == 0) {
                Element element = null;
                return element;
            }
            Element documentElement = DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(out.toByteArray())).getDocumentElement();
            PGInvocationContext.get().addTraceData(new Date(), invocationName.toString(), request, (Object)documentElement, null);
            Element element = documentElement;
            return element;
        }
        catch (Throwable t) {
            this.log.error("", t);
            PGInvocationContext.get().addTraceData(new Date(), invocationName.toString(), request, null, t);
            throw new PGException(out.toString());
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public PaymentType getSplitSupplierPaymentType() {
        return PaymentType.CREDIT_CARD_SUPPLIER_PAYONLINE;
    }

    public PaymentType getSplitAgencyPaymentType() {
        return PaymentType.CREDIT_CARD_AGENCY_PAYONLINE;
    }

    public PaymentType getSplitMainPaymentType() {
        return PaymentType.CREDIT_CARD_SPLIT_PAYONLINE;
    }

    public boolean canUseSplitScheme(EntityContainer<BookingFile> bfCtr) throws Exception {
        boolean canUseSplitScheme = PaymentHelper.canUseSplitScheme((BookingFile)((BookingFile)bfCtr.getEntity()));
        return canUseSplitScheme;
    }
}

