/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.payu;

import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.pg.model.Payment;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class PayuHelper {
    private static final DecimalFormat priceFormatter;

    private static double getPaymentAmount(Payment payment, boolean isTest) {
        if (isTest) {
            return new Double(2.0);
        }
        return payment.getAmount().doubleValue();
    }

    public static String getMerchantId(String pgAccount) {
        String[] vals;
        if (pgAccount.contains(";") && (vals = pgAccount.split(";")).length > 0) {
            return vals[0];
        }
        return pgAccount;
    }

    public static boolean isTwoStageMode(String pgAccount) {
        String[] vals;
        if (pgAccount.contains(";") && (vals = pgAccount.split(";")).length > 1) {
            return vals[1].equalsIgnoreCase("1");
        }
        return false;
    }

    public static String getPaymentAmountString(Payment payment, boolean isTest) {
        return priceFormatter.format(PayuHelper.getPaymentAmount(payment, isTest));
    }

    public static String getCurrency() {
        return DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
    }

    public static String getHMAC(String sig, String key) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes("UTF-8"), "HmacMD5");
        Mac mac = Mac.getInstance("HmacMD5");
        mac.init(keySpec);
        byte[] bytes = mac.doFinal(sig.getBytes("UTF-8"));
        StringBuffer hash = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hash.append('0');
            }
            hash.append(hex);
        }
        return hash.toString();
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        priceFormatter = new DecimalFormat("0.00", dfs);
    }
}

