/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.payu;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.payu.Configuration;
import com.gridnine.xtrip.server.pg.payu.HandlerCompletePayment;
import com.gridnine.xtrip.server.pg.payu.PayuHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayuPGServlet
extends PGServlet {
    private static final long serialVersionUID = 9083032265046450896L;
    private static final Logger log = LoggerFactory.getLogger(PayuPGServlet.class);

    protected PgName getId() {
        return PgName.PAYU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) {
        log.debug("service() BEGIN");
        log.debug("PayU - RequestURL - " + req.getRequestURL());
        log.debug("PayU - QueryString - " + req.getQueryString());
        PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
        Date startDate = new Date();
        Map request = PGHelper.convertRequestParametersMap((Map)req.getParameterMap());
        PGServletResponse response = new PGServletResponse(res);
        LinkedList<Message> messages = new LinkedList<Message>();
        LinkedList pgLog = new LinkedList();
        String paymentId = null;
        Payment payment = null;
        try {
            paymentId = req.getParameter("IPN_PCODE[]");
            if (TextUtil.isBlank((String)paymentId)) {
                throw new Exception("missing parameter 'IPN_PCODE[]'");
            }
            try (NamedLock lock = this.getLock(paymentId);){
                if (!lock.tryLock()) {
                    response.setResponseCode(500);
                    return;
                }
                try {
                    String pass;
                    LogicalStorage.get().authorizeAsSystem();
                    PGInvocationContext.get().setPaymentId(paymentId);
                    Configuration configuration = new Configuration(this.getConnector().getConfiguration());
                    payment = this.getFromQueue(paymentId);
                    if (payment == null) {
                        response.setResponseCode(200);
                    } else if (request.get("ORDERSTATUS") != null) {
                        SalesContext salesContext = PaymentHelper.restoreSalesContext((Payment)payment);
                        PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)salesContext, (PgName)PgName.PAYU, (Payment)payment);
                        HandlerCompletePayment.process(request, payment, messages);
                        boolean forAuthorized = false;
                        if (payment.getStatus() == PaymentStatus.SUCCEEDED) {
                            if (!PayuHelper.isTwoStageMode(pgParameters.getPgAccount())) {
                                this.paymentSucceeded(payment, messages);
                            }
                            response.setResponseCode(200);
                        } else if (payment.getStatus() == PaymentStatus.IN_PROGRESS) {
                            if (!PayuHelper.isTwoStageMode(pgParameters.getPgAccount())) {
                                this.paymentInitiated(payment, messages);
                            } else {
                                this.paymentSucceeded(payment, messages);
                                BookingFile bookingFile = (BookingFile)EntityStorage.get().resolve(payment.getEntity()).getEntity();
                                boolean allIssued = PaymentHelper.isAllIssued((BookingFile)bookingFile);
                                String preauthResponse = this.sendPreauthorizationConfirm(payment, configuration.getTwoStageConfirmUrl(), configuration.getTwoStageRefundUrl(), pgParameters, configuration.isTest(), req.getParameter("IPN_DATE"), pgParameters.getPgPassword(), !allIssued);
                                this.savePaymentStatusTO(payment);
                                log.debug("PreauthConfirmResponse: " + preauthResponse);
                            }
                            forAuthorized = true;
                            response.setResponseCode(200);
                        } else if (payment.getStatus() == PaymentStatus.FAILED) {
                            this.paymentFailed(payment, messages);
                            response.setResponseCode(200);
                        } else {
                            throw new Exception("could not determine payment status");
                        }
                        response.setResponseText("<EPAYMENT>" + req.getParameter("IPN_DATE") + "|" + this.getSignature(req, pgParameters.getPgPassword(), forAuthorized, configuration.isCorrectSignature()) + "</EPAYMENT>");
                    } else {
                        this.savePaymentStatusTO(payment);
                        response.setResponseCode(200);
                    }
                    if (payment == null && (pass = PayuPGServlet.getPgPass(req.getParameter("IPN_PNAME[]"))) != null) {
                        response.setResponseText("<EPAYMENT>" + req.getParameter("IPN_DATE") + "|" + this.getSignature(req, pass, false, configuration.isCorrectSignature()) + "</EPAYMENT>");
                    }
                    PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        catch (Throwable t) {
            log.error("service failed", t);
            response.setResponseCode(500);
            response.setResponseText(t.getMessage());
            PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, t);
        }
        finally {
            PGInvocationContext.get().end(this.getConnector(), pgLog);
            if (payment != null) {
                PGInvocationContext.get().saveDocs(pgLog, messages, payment.getPayee());
            }
            response.send();
            LogicalStorage.reset();
        }
        log.debug("service() END");
    }

    private static String getPgPass(String pnr) {
        List result;
        EntityContainer bf = null;
        try {
            result = PaymentHelper.searchBookingFile((String)pnr, (boolean)false);
        }
        catch (Exception e) {
            return null;
        }
        if (result.size() != 1) {
            return null;
        }
        try {
            bf = EntityStorage.get().resolve(((BookingFileIndex)result.get(0)).getSource());
        }
        catch (Exception e) {
            return null;
        }
        try {
            SalesContext ctx = PaymentHelper.restoreSalesContext((EntityContainer)bf);
            Payment payment = PaymentHelper.createPayment((EntityContainer)bf, (ContractType)ContractType.CLIENT);
            PGParameters pgp = PGRulesHelper.getPGParameters((SalesContext)ctx, (PgName)PgName.PAYU, (Payment)payment);
            if (pgp != null) {
                return pgp.getPgPassword();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private SSLSocketFactory getFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("TLSv1");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }
        }};
        KeyManager[] managers = new KeyManager[]{new X509KeyManager(){

            @Override
            public String[] getServerAliases(String arg0, Principal[] arg1) {
                return null;
            }

            @Override
            public PrivateKey getPrivateKey(String arg0) {
                return null;
            }

            @Override
            public String[] getClientAliases(String arg0, Principal[] arg1) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String arg0) {
                return null;
            }

            @Override
            public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
                return null;
            }

            @Override
            public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
                return null;
            }
        }};
        sc.init(managers, trustAllCerts, new SecureRandom());
        return sc.getSocketFactory();
    }

    private String createIData(Payment payment) {
        StringBuilder idata = new StringBuilder();
        EntityContainer bfCtr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(payment.getEntity());
        bfCtr.getVersionInfo().setDataSource("auto-ticketing");
        BookingFile bf = (BookingFile)bfCtr.getEntity();
        Reservation res = (Reservation)bf.getReservations().get(0);
        for (BaseProduct prod : res.getProducts()) {
            if (!(prod instanceof Product)) continue;
            Product product = (Product)prod;
            StringBuilder ticketNumber = new StringBuilder(TextUtil.nonNullStr((String)product.getCarrierNumber()) + TextUtil.nonNullStr((String)product.getSystemNumber()));
            while (ticketNumber.toString().length() < 14) {
                ticketNumber.insert(0, "0");
            }
            idata.append(ticketNumber.toString());
            break;
        }
        return idata.toString();
    }

    private StringBuilder createParamsString(HashMap<String, String> paramMap) throws UnsupportedEncodingException {
        StringBuilder params = new StringBuilder();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (params.length() > 0) {
                params.append("&");
            }
            params.append(key + "=" + URLEncoder.encode(value.trim(), "UTF-8"));
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendPreauthorizationConfirm(Payment payment, String twoStageConfirmUrl, String twoStageRefundUrl, PGParameters pgParameters, boolean isTest, String ipndate, String key, boolean refund) {
        InputStream in = null;
        DataOutputStream wr = null;
        try {
            String responseBody;
            URL url = new URL(refund ? twoStageRefundUrl : twoStageConfirmUrl);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setSSLSocketFactory(this.getFactory());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("MERCHANT", PayuHelper.getMerchantId(pgParameters.getPgAccount()));
            paramMap.put("ORDER_REF", payment.getPgPaymentId());
            paramMap.put("ORDER_AMOUNT", PayuHelper.getPaymentAmountString(payment, isTest));
            paramMap.put("ORDER_CURRENCY", PayuHelper.getCurrency());
            if (!refund) {
                paramMap.put("IDN_PRN", this.createIData(payment));
            }
            if (refund) {
                paramMap.put("IRN_DATE", ipndate);
            } else {
                paramMap.put("IDN_DATE", ipndate);
            }
            paramMap.put("ORDER_HASH", this.createIDNHash(PayuHelper.getMerchantId(pgParameters.getPgAccount()), PayuHelper.getPaymentAmountString(payment, isTest), PayuHelper.getCurrency(), payment.getPgPaymentId(), ipndate, key));
            StringBuilder params = this.createParamsString(paramMap);
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(params.toString().getBytes().length));
            connection.setUseCaches(false);
            wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(params.toString());
            wr.flush();
            int code = connection.getResponseCode();
            in = connection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                byte[] buf = new byte[12400];
                int i = 0;
                while ((i = in.read(buf)) != -1) {
                    baos.write(buf, 0, i);
                }
                responseBody = new String(baos.toByteArray(), "UTF-8");
            }
            finally {
                baos.close();
                in.close();
                if (wr != null) {
                    wr.close();
                }
            }
            Date startDate = new Date();
            paramMap.put("URL", twoStageConfirmUrl);
            responseBody = "httpresponsecode:" + Integer.toString(code) + ";" + responseBody;
            PGInvocationContext.get().addTraceData(startDate, InvocationName.PAYMENT_CONFIRM.toString(), paramMap, (Object)responseBody, null);
            String string = responseBody;
            return string;
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private String createIDNHash(String merchant, String amm, String cur, String payid, String date, String key) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        String sig = Integer.toString(merchant.length()) + merchant + Integer.toString(payid.length()) + payid + Integer.toString(amm.length()) + amm + Integer.toString(cur.length()) + cur + Integer.toString(date.length()) + date;
        return PayuHelper.getHMAC(sig, key);
    }

    private String getSignature(HttpServletRequest req, String key, boolean forAuthorized, boolean correctSignature) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        String ipnDate = req.getParameter("IPN_DATE");
        String pid = req.getParameter("IPN_PID[]");
        String date = req.getParameter("DATE");
        if (date == null) {
            date = "";
        }
        if (forAuthorized || correctSignature) {
            date = ipnDate;
        }
        String pname = req.getParameter("IPN_PNAME[]");
        String sig = Integer.toString(pid.length()) + pid + Integer.toString(pname.length()) + pname + Integer.toString(ipnDate.length()) + ipnDate + Integer.toString(date.length()) + date;
        return PayuHelper.getHMAC(sig, key);
    }

    private void savePaymentStatusTO(Payment payment) throws Exception {
        if (payment != null && payment.getStatus() != null && payment.getStatus().name() != null) {
            TemporalObject to = new TemporalObject(payment.getPaymentId());
            to.setExpired(new Date(System.currentTimeMillis() + 900000L));
            to.setTag("PAYUpaymentStatusTO");
            to.setData(payment.getStatus().name().getBytes());
            LogicalStorage.get().getAssetStorage().save((BaseAsset)to);
        }
    }
}

