/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.platron.common;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public final class PlatronHelper {
    private static final char HASH_SEPARATOR = ';';

    public static <E extends BaseEntity> String calculateHash(E object, String url, String secretKey) {
        LinkedList values = new LinkedList(((EntityType)((MetaRegistry)Environment.getPublished(MetaRegistry.class)).getEntities().get(object.getClass().getName())).getProperties().values());
        Collections.sort(values, new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                return TextUtil.compare((String)o1.getId(), (String)o2.getId(), (boolean)false, (boolean)false);
            }
        });
        StringBuilder hashdata = new StringBuilder();
        int beginIndex = url.lastIndexOf(47) + 1;
        int endIndex = url.lastIndexOf(63);
        if (endIndex == -1) {
            hashdata.append(url.substring(beginIndex));
        } else {
            hashdata.append(url.substring(beginIndex, endIndex));
        }
        hashdata.append(';');
        for (Property item : values) {
            Object value;
            if (item.getId().equals("pg_sig") || (value = object.getValue(item.getId())) == null) continue;
            hashdata.append(value).append(';');
        }
        hashdata.append(secretKey);
        return MiscUtil.md5((String)hashdata.toString());
    }

    public static String getErrorText(String codeStr) {
        if (TextUtil.isBlank((String)codeStr)) {
            return "\u043d\u0435 \u0437\u0430\u0434\u0430\u043d";
        }
        switch (Integer.parseInt(codeStr)) {
            case 100: {
                return "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u0430";
            }
            case 101: {
                return "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430";
            }
            case 110: {
                return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u043d\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442 \u0441 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u043c";
            }
            case 120: {
                return "\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043d\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u0445 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430";
            }
            case 200: {
                return "\u041d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0438\u043b\u0438 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430";
            }
            case 340: {
                return "\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
            }
            case 350: {
                return "\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430";
            }
            case 360: {
                return "\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u0430";
            }
            case 400: {
                return "\u041f\u043b\u0430\u0442\u0435\u0436 \u043e\u0442\u043c\u0435\u043d\u0435\u043d \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u0435\u043c \u0438\u043b\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439";
            }
            case 420: {
                return "\u041f\u043b\u0430\u0442\u0435\u0436 \u043e\u0442\u043c\u0435\u043d\u0435\u043d \u043f\u043e \u043f\u0440\u0438\u0447\u0438\u043d\u0435 \u043f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430";
            }
            case 490: {
                return "\u041e\u0442\u043c\u0435\u043d\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430";
            }
            case 600: {
                return "\u041e\u0431\u0449\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
            }
            case 700: {
                return "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u0435\u043c";
            }
            case 701: {
                return "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430";
            }
            case 711: {
                return "\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u043d\u0435\u043f\u0440\u0438\u0435\u043c\u043b\u0435\u043c \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u041f\u0421";
            }
            case 1000: {
                return "\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 (\u043c\u043e\u0436\u0435\u0442 \u043d\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c\u0441\u044f \u043f\u0440\u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e\u043c \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0438)";
            }
        }
        return "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 " + codeStr;
    }

    private PlatronHelper() {
    }
}

