/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ibus.platron.init;

import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.IBusPgContextKeys;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.platron.PlatronConfiguration;
import com.gridnine.xtrip.common.pg.platron.PlatronInitPaymentRequest;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class PlatronInitPaymentPrepareRequestProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer customerCtr;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat priceFormat = new DecimalFormat("0.00", dfs);
        PlatronConfiguration config = (PlatronConfiguration)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PG_CONFIGURATION);
        PlatronInitPaymentRequest request = new PlatronInitPaymentRequest();
        PGParameters pgParams = (PGParameters)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PG_PARAMETERS);
        request.setPg_merchant_id(pgParams.getPgAccount());
        request.setPg_order_id(UUIDGenerator.generate().toString());
        ctx.putObject((Enum)IBusPgContextKeys.ORDER_ID, (Object)request.getPg_order_id());
        request.setPg_amount(priceFormat.format(ctx.getMandatoryObject((Enum)IBusPgContextKeys.BOOKING_PRICE)));
        request.setPg_currency("RUB");
        request.setPg_result_url(config.getResultUrl());
        request.setPg_request_method("XML");
        String returnUrl = (String)ctx.getMandatoryObject((Enum)IBusPgContextKeys.RETURN_URL);
        request.setPg_success_url(returnUrl + "&status=1");
        request.setPg_success_url_method(config.getReturnUrlMethod());
        request.setPg_failure_url(returnUrl + "&status=0");
        request.setPg_failure_url_method(config.getReturnUrlMethod());
        PaymentType pt = (PaymentType)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PAYMENT_TYPE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusPgContextKeys.SALES_CONTEXT);
        request.setPg_payment_system(this.paymentType2String(pt));
        if (pt == PaymentType.BANKCARDPRU_PLATRON && (customerCtr = EntityStorage.get().resolve(salesContext.getCustomer())) != null) {
            for (PersonCommunication comm : ((Person)customerCtr.getEntity()).getCommunications()) {
                if (comm.getType() != CommunicationType.EMAIL) continue;
                request.setPg_user_email("pg_user_email");
                break;
            }
        }
        request.setPg_description((String)ctx.getMandatoryObject((Enum)IBusPgContextKeys.BOOKING_DESCRIPTION));
        request.setPg_user_ip((String)ctx.getMandatoryObject((Enum)IBusPgContextKeys.USER_IP));
        EntityContainer ctr = EntityStorage.get().resolve(salesContext.getCustomer());
        if (ctr != null && ((Person)ctr.getEntity()).getPreferredLocale() != null) {
            request.setPg_language(((Person)ctr.getEntity()).getPreferredLocale().getLanguage());
        } else {
            request.setPg_language("ru");
        }
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusPgContextKeys.BOOKING_CONTAINER);
        GdsName gdsName = (GdsName)ctx.getMandatoryObject((Enum)IBusPgContextKeys.GDS_OF_FIRST_RESERVATION);
        if (gdsName != null) {
            request.setPg_gds(gdsName.name());
        }
        if (!((BookingFile)bookingCtr.getEntity()).getReservations().isEmpty()) {
            Reservation reservation = (Reservation)((BookingFile)bookingCtr.getEntity()).getReservations().get(0);
            request.setPg_rec_loc(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        }
        if (config.getTestingMerchantMarkup() != null) {
            request.setPg_merchant_markup(priceFormat.format(config.getTestingMerchantMarkup()));
        } else {
            BigDecimal total = BookingHelper.getTotalPrice((BookingFile)((BookingFile)bookingCtr.getEntity()), (ContractType)ContractType.CLIENT);
            BigDecimal fee = BookingHelper.getTotalFee((BookingFile)((BookingFile)bookingCtr.getEntity()), (ContractType)ContractType.CLIENT);
            if (fee != null) {
                total = total.subtract(fee);
            }
            request.setPg_merchant_markup(priceFormat.format(total));
        }
        if (config.isTestingMode()) {
            request.setPg_testing_mode("1");
        }
        ctx.putObject((Enum)IBusPgContextKeys.REQUEST_MODEL_OBJECT, (Object)request);
    }

    private String paymentType2String(PaymentType paymentType) {
        switch (paymentType) {
            case OSMPII_PLATRON: {
                return "OSMP-II";
            }
            case RUSSIANSTANDARD_PLATRON2: {
                return "GDSWITHRUSSIANSTANDARD";
            }
        }
        return paymentType.name().replaceAll("_PLATRON", "");
    }
}

