/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.platron;

import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class Configuration {
    private final String resultUrl;
    private final Map<InvocationName, String> urls = new HashMap<InvocationName, String>();
    private final boolean traceEnabled;
    private final Long queuePeriod;
    private final boolean testingModeEnabled;
    private final String testPgMerchantMarkup;
    private final String revokeUrl;
    private final String urlMethod;

    Configuration(Properties configuration) {
        this.resultUrl = configuration.getProperty("result.url");
        this.traceEnabled = "true".equals(configuration.getProperty("trace.enabled"));
        this.testingModeEnabled = "true".equals(configuration.getProperty("testing_mode.enabled"));
        this.testPgMerchantMarkup = configuration.getProperty("testing_mode.pg_merchant_markup");
        for (Object obj : configuration.keySet()) {
            String property = (String)obj;
            if (!property.startsWith("url.")) continue;
            this.urls.put(InvocationName.valueOf((String)property.substring(4)), configuration.getProperty(property));
        }
        this.revokeUrl = configuration.getProperty("revoke.url");
        this.urlMethod = configuration.containsKey("return.url.method") ? configuration.getProperty("return.url.method") : "POST";
        this.queuePeriod = configuration.containsKey("queue.period") ? Long.valueOf(configuration.getProperty("queue.period")) : null;
    }

    String getResultUrl() {
        return this.resultUrl;
    }

    String getUrl(InvocationName value) {
        return this.urls.get(value);
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    boolean isValid() {
        return !TextUtil.isBlank((String)this.resultUrl) && this.urls.containsKey(InvocationName.INITIATE_PAYMENT) && this.urls.containsKey(InvocationName.CHECK_PAYMENT);
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    boolean isTestingModeEnabled() {
        return this.testingModeEnabled;
    }

    public String getTestPgMerchantMarkup() {
        return this.testPgMerchantMarkup;
    }

    public String getRevokeUrl() {
        return this.revokeUrl;
    }

    public String getUrlMethod() {
        return this.urlMethod;
    }
}

