/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.platron;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.RedirectForm;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.platron.Configuration;
import com.gridnine.xtrip.server.pg.platron.Util;
import com.gridnine.xtrip.server.pg.split.SplitPaymentHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HandlerInitiatePayment {
    private static NumberFormat priceFormat;

    public static void buildRedirectForm(String redirectUrl, RedirectForm redirectForm) {
        redirectForm.setUrl(redirectUrl);
        redirectForm.setMethod("GET");
        int indexOf = redirectUrl.indexOf(63);
        if (indexOf == -1) {
            redirectForm.setUrl(redirectUrl);
        } else {
            redirectForm.setUrl(redirectUrl.substring(0, indexOf));
            for (String paramEntry : redirectUrl.substring(indexOf + 1).split("&")) {
                int equalChar = paramEntry.indexOf(61);
                redirectForm.getParameters().add(NamedValueHelper.namedValue((String)paramEntry.substring(0, equalChar), (String)paramEntry.substring(equalChar + 1)));
            }
        }
    }

    static Element prepareRequest(PGParameters pgParameters, PaymentInitiationParameters parameters, Configuration configuration) throws Exception {
        Object phoneCommunications;
        Document doc = DocumentBuilderHelper.newDocument();
        Element request = doc.createElement("request");
        doc.appendChild(request);
        XHelper.writeString((Element)request, (String)"pg_merchant_id", (String)pgParameters.getPgAccount());
        Payment payment = parameters.getPayment();
        XHelper.writeString((Element)request, (String)"pg_order_id", (String)payment.getPaymentId());
        BigDecimal totalAmount = payment.getAmount();
        XHelper.writeString((Element)request, (String)"pg_amount", (String)priceFormat.format(totalAmount.doubleValue()));
        XHelper.writeString((Element)request, (String)"pg_currency", (String)"RUB");
        XHelper.writeString((Element)request, (String)"pg_result_url", (String)configuration.getResultUrl());
        XHelper.writeString((Element)request, (String)"pg_request_method", (String)"XML");
        XHelper.writeString((Element)request, (String)"pg_success_url", (String)(parameters.getReturnUrl() + "&status=1"));
        XHelper.writeString((Element)request, (String)"pg_failure_url", (String)(parameters.getReturnUrl() + "&status=0"));
        XHelper.writeString((Element)request, (String)"pg_success_url_method", (String)configuration.getUrlMethod());
        XHelper.writeString((Element)request, (String)"pg_failure_url_method", (String)configuration.getUrlMethod());
        XHelper.writeString((Element)request, (String)"pg_payment_system", (String)Util.paymentType2String(payment.getPaymentType()));
        Person customer = null;
        if (parameters.getSalesContext().getCustomer() != null && (customer = (Person)EntityStorage.get().resolve(parameters.getSalesContext().getCustomer()).getEntity()) != null && (phoneCommunications = ProfileHelper.getPhoneCommunications((List)customer.getCommunications())).size() > 0) {
            String phone = ProfileHelper.buildFullPhoneNumber((Communication)((Communication)phoneCommunications.iterator().next())).replace("+", "").replace("(", "").replace(")", "").replace(" ", "");
            XHelper.writeString((Element)request, (String)"pg_user_phone", (String)phone);
        }
        if (payment.getPaymentType() == PaymentType.BANKCARDPRU_PLATRON && customer != null) {
            for (PersonCommunication comm : customer.getCommunications()) {
                if (comm.getType() != CommunicationType.EMAIL) continue;
                XHelper.writeString((Element)request, (String)"pg_user_email", (String)comm.getSense());
                break;
            }
        }
        XHelper.writeString((Element)request, (String)"pg_description", (String)payment.getDescription());
        XHelper.writeString((Element)request, (String)"pg_language", (String)payment.getCustomerInfo().getPreferredLocale().getLanguage());
        if (configuration.isTestingModeEnabled()) {
            XHelper.writeString((Element)request, (String)"pg_testing_mode", (String)"1");
        }
        if (payment.getPaymentType() == PaymentType.GDS_WITH_RUSSIANSTANDARD_SPLIT_PLATRON) {
            EntityContainer bookingFile = PaymentHelper.getBookingFileContainer((Payment)payment);
            Reservation aviaReservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)bookingFile.getEntity()));
            String pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)aviaReservation);
            XHelper.writeString((Element)request, (String)"pg_rec_loc", (String)pnr);
            XHelper.writeString((Element)request, (String)"pg_gds", (String)"SABRE");
            BigDecimal commissionAmount = SplitPaymentHelper.getSplitPaymentCommisionPartAmount((BookingFile)((BookingFile)bookingFile.getEntity()), (BigDecimal)totalAmount);
            XHelper.writeString((Element)request, (String)"pg_merchant_markup", (String)priceFormat.format(commissionAmount));
            Set acceptedCards = PaymentHelper.getAcceptedCards((BookingFile)((BookingFile)bookingFile.getEntity()));
            for (AirlineCard airlineCard : acceptedCards) {
                XHelper.writeString((Element)request, (String)"pg_card_brand", (String)airlineCard.getCode());
            }
        }
        return request;
    }

    static void processResponse(PaymentInitiationResult result, Element response) throws PGException {
        if (!"ok".equals(XHelper.readString((Element)response, (String)"pg_status"))) {
            int errorCode = XHelper.readInt((Element)response, (String)"pg_error_code", (int)-1);
            String errorDescription = XHelper.readString((Element)response, (String)"pg_error_description");
            throw new PGException("\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: " + errorCode + " (" + Util.getErrorText(errorCode) + ") " + errorDescription);
        }
        result.getPayment().setPgPaymentId(XHelper.readString((Element)response, (String)"pg_payment_id"));
        HandlerInitiatePayment.buildRedirectForm(XHelper.readString((Element)response, (String)"pg_redirect_url"), result.getRedirectForm());
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        priceFormat = new DecimalFormat("0.00", dfs);
    }
}

