/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.platron;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class HandlerSecurity {
    private static final Logger log = LoggerFactory.getLogger(HandlerSecurity.class);
    private static final char HASH_SEPARATOR = ';';

    HandlerSecurity() {
    }

    static void injectSecurity(Element request, String url, String secretKey) {
        XHelper.writeString((Element)request, (String)"pg_salt", (String)UUID.randomUUID().toString().replaceAll("-", ""));
        XHelper.writeString((Element)request, (String)"pg_sig", (String)HandlerSecurity.calculateHash(request, url, secretKey));
    }

    static void checkSecurity(Element request, String url, String secretKey) throws SecurityException {
        if (!HandlerSecurity.calculateHash(request, url, secretKey).equals(XHelper.readString((Element)request, (String)"pg_sig"))) {
            throw new SecurityException("signature not valid");
        }
    }

    static String buildSecurityLine(Element request, String url, String secretKey) {
        StringBuilder hashdata = new StringBuilder();
        int beginIndex = url.lastIndexOf(47) + 1;
        int endIndex = url.lastIndexOf(63);
        if (endIndex == -1) {
            hashdata.append(url.substring(beginIndex));
        } else {
            hashdata.append(url.substring(beginIndex, endIndex));
        }
        hashdata.append(';');
        HandlerSecurity.appendNodeValues(hashdata, request);
        hashdata.append(secretKey);
        log.debug("signature: " + hashdata);
        return hashdata.toString();
    }

    private static String calculateHash(Element request, String url, String secretKey) {
        String buildSecurityLine = HandlerSecurity.buildSecurityLine(request, url, secretKey);
        return MiscUtil.md5((String)buildSecurityLine);
    }

    private static void appendNodeValues(StringBuilder hashdata, Element element) {
        Element[] children = XmlUtil.getElements((Element)element, (String)"./*");
        ArrayList<MiscUtil.Pair> sortedElem = new ArrayList<MiscUtil.Pair>(children.length);
        int index = 0;
        for (Element child : children) {
            String sortName = child.getNodeName() + "_" + index++;
            sortedElem.add(new MiscUtil.Pair((Object)sortName, (Object)child));
        }
        Collections.sort(sortedElem, new Comparator<MiscUtil.Pair<String, Element>>(){

            @Override
            public int compare(MiscUtil.Pair<String, Element> o1, MiscUtil.Pair<String, Element> o2) {
                return ((String)o1.getFirst()).compareTo((String)o2.getFirst());
            }
        });
        for (MiscUtil.Pair childName : sortedElem) {
            String elemNodeName = ((Element)childName.getSecond()).getNodeName();
            if ("pg_sig".equals(elemNodeName)) continue;
            if (XmlUtil.getElements((Element)element, (String)(elemNodeName + "/*")).length > 0) {
                HandlerSecurity.appendNodeValues(hashdata, XmlUtil.getElement((Element)element, (String)elemNodeName));
                continue;
            }
            String value = XmlUtil.getValue((Element)((Element)childName.getSecond()));
            hashdata.append(value);
            hashdata.append(';');
        }
    }
}

