/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.platron;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.platron.Configuration;
import com.gridnine.xtrip.server.pg.platron.HandlerInitiatePayment;
import com.gridnine.xtrip.server.pg.platron.HandlerRevokePayment;
import com.gridnine.xtrip.server.pg.platron.HandlerSecurity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.LinkedList;
import javax.net.ssl.HttpsURLConnection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Platron2PGConnector
extends PGConnector {
    private boolean disposed;
    private boolean enabled;
    private Configuration configuration;
    private Tracer tracer;

    public PgName getId() {
        return PgName.PLATRON2;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.enabled;
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.RUSSIANSTANDARD_PLATRON2);
        return result;
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        Payment payment = parameters.getPayment();
        this.doPaymentReprice(payment);
        PGInvocationContext.get().begin(InvocationName.INITIATE_PAYMENT.toString());
        Date startDate = new Date();
        PGInvocationContext.get().setPaymentId(payment.getPaymentId());
        PaymentInitiationResult result = new PaymentInitiationResult();
        Element request = null;
        Element response = null;
        try {
            result.setPayment((Payment)XCloneHelper.clone((XCloneable)payment));
            PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)parameters.getSalesContext(), (PgName)parameters.getPg(), (Payment)payment);
            request = HandlerInitiatePayment.prepareRequest(pgParameters, parameters, this.configuration);
            response = this.execute(this.configuration.getUrl(InvocationName.INITIATE_PAYMENT), pgParameters, request);
            HandlerSecurity.checkSecurity(response, this.configuration.getUrl(InvocationName.INITIATE_PAYMENT), pgParameters.getPgPassword());
            HandlerInitiatePayment.processResponse(result, response);
            this.paymentInitiated(result.getPayment(), result.getMessages());
            result.setSuccess(true);
            result.getMessages().add(MessageHelper.createMessage((String)"\u041f\u043b\u0430\u0442\u0435\u0436 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d", (String)result.getPayment().getPaymentId(), (Object[])new Object[]{PgName.PLATRON2}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)request, (Object)response, null);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (PGException ex) {
            this.log.error("payment initiation failed", (Throwable)ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)request, (Object)response, (Throwable)ex);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (Throwable t) {
            this.log.error("payment initiation failed", t);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)t));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)"\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", (String)payment.getPaymentId(), (Object[])new Object[]{PgName.PLATRON2}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)request, (Object)response, t);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, result.getPgLog());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        PGParameters pgParameters;
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        Date startDate = new Date();
        PaymentCheckResult result = new PaymentCheckResult();
        Payment payment = parameters.getPayment();
        SalesContext pgSalesCtx = null;
        try {
            pgSalesCtx = PaymentHelper.restoreSalesContext((Payment)payment);
            pgParameters = PGRulesHelper.getPGParameters((SalesContext)pgSalesCtx, (PgName)this.getId(), (Payment)payment);
        }
        catch (Exception ex) {
            PGInvocationContext.get().begin(InvocationName.CHECK_PAYMENT.toString());
            this.log.error("check payment failed", (Throwable)ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.setPaymentStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.CHECK_PAYMENT.toString(), null, null, (Throwable)ex);
            PGInvocationContext.get().end((PGConnector)this, result.getPgLog());
            return result;
        }
        try {
            LogicalStorage.get().authorizeAsSystem();
            EntityContainer bfCtr = EntityStorage.get().resolve(payment.getEntity());
            boolean allIssued = true;
            block7: for (Reservation reservation : ((BookingFile)bfCtr.getEntity()).getReservations()) {
                for (BaseProduct bp : reservation.getProducts()) {
                    if (!(bp instanceof Product)) continue;
                    if (((Product)bp).getStatus() == ProductStatus.SELL) break block7;
                    allIssued = false;
                    break block7;
                }
            }
            if (allIssued) {
                result.setSuccess(true);
                result.setPaymentStatus(PaymentStatus.SUCCEEDED);
                this.paymentSucceeded(payment, result.getMessages());
            } else {
                result.setPaymentStatus(PaymentStatus.FAILED);
                this.paymentFailed(payment, result.getMessages());
                this.revoke(pgParameters, parameters, result, startDate);
            }
        }
        catch (Throwable t) {
            PGInvocationContext.get().begin(InvocationName.CHECK_PAYMENT.toString());
            this.log.error("error while issuing", t);
            result.setSuccess(false);
            result.setPaymentStatus(PaymentStatus.FAILED);
            this.revoke(pgParameters, parameters, result, startDate);
            PGInvocationContext.get().addTraceData(startDate, InvocationName.CHECK_PAYMENT.toString(), null, null, t);
            PGInvocationContext.get().end((PGConnector)this, result.getPgLog());
            PaymentCheckResult paymentCheckResult = result;
            return paymentCheckResult;
        }
        finally {
            LogicalStorage.reset();
        }
        return result;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.enabled = true;
        this.configuration = new Configuration(this.getConfiguration());
        if (this.configuration.isTraceEnabled()) {
            this.tracer = PGHelper.createTracer((PgName)this.getId());
        }
        this.enabled = this.configuration.isValid();
        if (this.enabled) {
            this.log.debug("configured");
        } else {
            this.log.warn("invalid configuration, Platron 2 connector disabled");
        }
    }

    Configuration getConnectorConfiguration() {
        return this.configuration;
    }

    protected Long getQueuePeriod() {
        return this.configuration.getQueuePeriod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element execute(String url, PGParameters pgParameters, Element request) throws Exception {
        HandlerSecurity.injectSecurity(request, url, pgParameters.getPgPassword());
        this.log.debug("opening connection, url: " + url);
        HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        try {
            connection.getOutputStream().write(new String("pg_xml=" + URLEncoder.encode(XUtil.toString((Document)request.getOwnerDocument()).replaceAll(">\\s+<", "><"), "UTF-8")).getBytes());
        }
        finally {
            connection.getOutputStream().flush();
            connection.getOutputStream().close();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DataInputStream in = new DataInputStream(connection.getInputStream());){
            IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)256);
        }
        try {
            Element response;
            Element element = response = DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(out.toByteArray())).getDocumentElement();
            return element;
        }
        catch (Throwable t) {
            throw new PGException(t.getMessage(), t);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revoke(PGParameters pgParameters, PaymentCheckParameters parameters, PaymentCheckResult result, Date startDate) {
        PGInvocationContext.get().begin("revokePayment");
        Element request = null;
        Element response = null;
        try {
            request = HandlerRevokePayment.prepareRequest(pgParameters, parameters, this.configuration);
            response = this.execute(this.configuration.getRevokeUrl(), pgParameters, request);
            HandlerRevokePayment.processRepsonse(response, this.configuration);
            PGInvocationContext.get().addTraceData(startDate, "revokePayment", (Object)request, (Object)response, null);
        }
        catch (Exception ex) {
            this.log.error("revoke payment failed", (Throwable)ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.setPaymentStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
            PGInvocationContext.get().addTraceData(startDate, "revokePayment", (Object)request, (Object)response, (Throwable)ex);
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, new LinkedList());
        }
    }
}

